package base;

import java.util.Set;
import java.util.SortedSet;
import java.util.Map.Entry;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;

public class ProgressingDynamic implements Dynamic {

	private final ImmutableMap.Builder<SupportState, SupportState> mapBacking = ImmutableMap.builder();
	private final ImmutableList<ImmutableSetMultimap.Builder<VertexState,SortedSet<Integer>>> precursorbacker;
	
	private ImmutableMap<SupportState,SupportState> map;
	private ImmutableSetMultimap<VertexState,SortedSet<Integer>>[] precursor;

	public ProgressingDynamic(int size) {
		ImmutableList.Builder<ImmutableSetMultimap.Builder<VertexState,SortedSet<Integer>>> builder = ImmutableList.builder();
		precursorbacker = builder.build();
		all = SupportState.allOfSize(size);
	}
	
	public ProgressingDynamic append(SupportState to, SupportState from, SupportState...otherFroms) {
		if (map.containsKey(from)) throw new IllegalArgumentException();
		mapBacking.put(from, to);
		for (SupportState oFrom : otherFroms) {
			if (map.containsKey(from)) throw new IllegalArgumentException();
			mapBacking.put(oFrom, to);
		}
		
		map = mapBacking.build();
		
		return this;
	}
		
	public ProgressingDynamic append(Iterable<Entry<SupportState,SupportState>> newTransitions) {
		//TODO do
		return null;
	}
	
	@Override public SetMultimap<VertexState, SortedSet<Integer>> precursors(Integer which) { return precursor[which]; }

	@Override
	public int activity() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override public Set<SupportState> fixedSources() { return map.keySet(); }

	@Override public SupportState get(SupportState from) { return map.get(from); }

	private Predicate<SupportState> unfixed;
	private final Iterable<SupportState> all;
	@Override
	public Iterable<SupportState> unfixedSources() {
		return Iterables.filter(all, unfixed);
	}

	@Override
	public Set<Integer> vertices() {
		// TODO Auto-generated method stub
		return null;
	}
	
}
