package test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;

import org.junit.Before;

import base.Edge;
import base.FlexibleComponents;

import com.google.common.collect.ImmutableSet;


public class FlexibleComponentEmptyTest extends FlexibleComponentTest {
		
	@Before public void setUp() {
		testObject = FlexibleComponents.make(ImmutableSet.<Integer>of(), ImmutableSet.<Integer>of());
	}
		
	@Override public void testIsEmpty() {
		assertEquals(true, testObject.isEmpty());
	}

	@Override public void testSize() {
		assertEquals(0, testObject.size());
	}

	@Override public void testContents() {
		for (Edge e : Edge.all) assertTrue(testObject.get(e).isEmpty());
	}
	
	@Override public void testEquals() {
		assertSame(testObject, FlexibleComponents.make());
	}
		
	@Override public void testAppendOne() {
		assertEquals(testObject.append(activators,Edge.TURN_ON), FlexibleComponents.make(ImmutableSet.<Integer>of(),activators));
		assertEquals(testObject.append(inhibitors,Edge.TURN_OFF), FlexibleComponents.make(inhibitors, ImmutableSet.<Integer>of()));
	}
	
	@Override public void testAppendBoth() {
		assertEquals(testObject.append(inhibitors, activators),FlexibleComponents.make(inhibitors, activators));
		assertEquals(testObject.append(activators, Edge.TURN_ON).append(inhibitors, Edge.TURN_OFF), FlexibleComponents.make(inhibitors, activators));
	}
	
}
