package test;

import static org.junit.Assert.*;

import java.util.Collections;

import org.junit.Test;

import collect.Range;

public class RangeTest {

	@Test public void testSingleton() {
		Range tested = Range.range(0);
		assertEquals(Collections.singletonList(0),tested);
		assertEquals(Collections.singleton(0),tested);
		assertTrue(tested.contains(0));
		assertFalse(tested.contains(1));
		assertTrue(tested.headSet(0).isEmpty());
		assertFalse(tested.tailSet(0).isEmpty());
	}
	
	@Test public void testARange() {
		int first = -1;
		int last = 10;
		Range tested = Range.range(first, last);
		for (int i = first; i <= last; i++) assertTrue(tested.contains(i));
		for (int i = 0; i < tested.size(); i++) {
			assertEquals((Integer)(i+first), tested.get(i));
			assertEquals(tested.size() - i, tested.tailSet(tested.get(i)).size());
			assertEquals(i, tested.headSet(tested.get(i)).size());
		}
	}
	
	@Test public void testHeadsAndTails() {
		int first = -1;
		int last = 10;
		Range tested = Range.range(first, last);
		int lowcut = 3;
		int highcut = 7;
		assertEquals(tested.subSet(lowcut, highcut),tested.tailSet(lowcut).headSet(highcut));
		assertEquals(tested.subSet(lowcut, highcut),tested.subList(tested.indexOf(lowcut), tested.indexOf(highcut)));
	}
	
	@Test public void testIndexing() {
		int first = -1;
		int last = 10;
		Range tested = Range.range(first, last);
		for (int i=0; i < tested.size(); i++) {
			assertEquals(i, tested.indexOf(tested.get(i)));
		}
	}
	
}
