import java.io.*;

public class Tree234ConsoleTester {
	public static void main(String[] args) throws IOException
	{
		int value;
		Tree234<Integer> theTree = new Tree234<Integer>();
		boolean loop = true;

		theTree.insert(50);
		theTree.insert(40);
		theTree.insert(60);
		theTree.insert(30);
		theTree.insert(70);

		while (loop)
		{
			putText("Enter first letter of ");
			putText("show, insert, find, empty, delete or quit: ");
			char choice = getChar();
			switch (choice) {
			case 's':
				theTree.displayTreeConsole();
				break;
			case 'i':
				putText("Enter value to insert: ");
				value = getInt();
				try
				{
					theTree.insert(value);
				} catch (DuplicateItemException e)
				{
					System.out.println("Entry (" + value + ") is "
							+ "already in the tree");
				}
				break;
			case 'f':
				putText("Enter value to find: ");
				value = getInt();
				boolean found = theTree.search(value);
				if (found == true)
					System.out.println("Found " + value);
				else
					System.out.println("Could not find " + value);
				break;
			case 'e':
				theTree.clear();
				break;
			case 'd':
				putText("Enter value to delete: ");
				value = getInt();
				try
				{
					theTree.delete(value);
				} catch (ItemNotFoundException e)
				{
					System.out.println("Entry (" + value + ") is "
							+ "not in the tree");
				}
				break;
			case 'q':
				loop = false;
				break;
			default:
				putText("Invalid entry\n");
			}
		}
	}

	public static void putText(String s)
	{
		System.out.print(s);
		System.out.flush();
	}

	public static String getString() throws IOException
	{
		InputStreamReader isr = new InputStreamReader(System.in);
		BufferedReader br = new BufferedReader(isr);
		String s = br.readLine();
		return s;
	}

	public static char getChar() throws IOException
	{
		String s = getString();
		return s.charAt(0);
	}

	public static int getInt() throws IOException
	{
		String s = getString();
		return Integer.parseInt(s);
	}
}