//*******1*********2*********3*********4*********5*********6*********7*********8
/* 
 Tree234GraphPanel.java
 Daniel Johnson
 johnda09@metrostate.edu
 */

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JPanel;

/**
 * 
 * @author johnda09@metrostate.edu
 * 
 */
@SuppressWarnings("serial")
public class Tree234GraphPanel<AnyType extends Comparable<? super AnyType>>
		extends JPanel {

	/**
	 * Constructs blank Tree graph
	 * 
	 */
	public Tree234GraphPanel()
	{
		this(null, new Point(0, 0));
	}

	/**
	 * Constructs a panel on which the given Tree's graphic is to be placed.
	 * 
	 * @param graph_tree
	 *            - the tree with nodes that are to be drawn
	 * @param top_center
	 *            - the position to center the root node
	 */
	public Tree234GraphPanel(Tree234<AnyType> graph_tree, Point top_center)
	{
		this.graphTree = graph_tree;
		this.rootCenter = top_center;
	}

	/**
	 * Draws the graphic representation of a Tree
	 * 
	 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
	 */
	@Override
	protected void paintComponent(Graphics g)
	{
		// Needed to clear area
		super.paintComponent(g);

		if (graphTree != null && !graphTree.isCleared())
		{
			Graphics2D g2d = (Graphics2D) g;

			// Set center coordinates for tree nodes
			graphTree.setLocation(rootCenter);

			// Minimize spread of tree
			graphTree.compressDrawWidth();

			// Move tree to minimum left extent
			graphTree.setLeftEdgeGap(TREE_BORDER_OFFSET);

			// Construct tree graphic
			graphTree.drawTree(g2d);
		}
	}

	// Default space between edge of drawing area center of closest node
	public static final int TREE_BORDER_OFFSET = 20;

	// Tree that will be graphed
	private Tree234<AnyType> graphTree;
	private Point rootCenter;
}
