package co.edu.udea.ingweb.inventariomoduloii.dao;

import java.util.List;

import co.edu.udea.ingweb.inventariomoduloii.model.AlertaCreada;

/**
 * 
 * @author Yefry Alexis Caldern Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 * 
 *          Interfaz de acceso a los datos de la tabla Alerta Creada
 */

public interface DAOAlertaCreada {

	/**
	 * Mtodo que devuelve todos las alertas creada que se encuentran
	 * actualmente en la Base de Datos
	 * 
	 * @return Listado de entidades de tipo Alerta Creada
	 */
	public List<AlertaCreada> getCreatedAlerts();

	/**
	 * M&eacute;todo que retorna una alerta creada de la base de datos, el cual
	 * se busca por su clave primaria que es el idAlertaCreada
	 * 
	 * @return
	 */
	public AlertaCreada getCreatedAlert(int idAlertaCreada);

	/**
	 * M&eacute;todo que guarda una instancia de tipo Alerta Creada en la base
	 * de datos
	 */
	public void saveCreatedAlert(AlertaCreada alertaCreada);

	/**
	 * M&eacute;todo que elimina una instancia de tipo Alerta Creada de la base
	 * de datos
	 * 
	 * @param usuario
	 *            Instancia de Usuario que se desea eliminar
	 */
	public void deleteCreatedAlert(AlertaCreada alertaCreada);

	/**
	 * M&eacute;todo que permite realizar la edicin de una instancia de tipo
	 * usuario de la base de datos
	 */
	public void editCreatedAlert(AlertaCreada alertaCreada);

}
