package co.edu.udea.ingweb.inventariomoduloii.dao;

import java.util.List;

import co.edu.udea.ingweb.inventariomoduloii.model.Usuario;

/**
 * 
 * @author Yefry Alexis Caldern Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 * 
 *         Interfaz de acceso a los datos de la tabla Usuario
 *
 */
public interface DAOUser {

	/**
	 * Mtodo que devuelve todos los usuarios que se encuentran actualmente en
	 * la Base de Datos
	 * 
	 * @return Listado de entidades de tipo Usuario
	 */
	public List<Usuario> getUsers();

	/**
	 * M&eacute;todo que retorna un usuario de la base de datos, el cual se
	 * busca por su clave primaria que es la cedula del Usuario
	 * 
	 * @param cedula clave primaria de la tabla Usuario
	 * @return Instancia de categora
	 */
	public Usuario getUser(int cedula);

	/**
	 * M&eacute;todo que guarda una instancia de tipo Usuario en la base de
	 * datos
	 * 
	 * @param usuario Instancia del usuario que se desea guardar
	 */
	public void saveUser(Usuario usuario);

	/**
	 * M&eacute;todo que elimina una instancia de tipo Usuario de la base de
	 * datos
	 * 
	 * @param usuario Instancia de Usuario que se desea eliminar
	 */
	public void deleteUser(Usuario usuario);

	/**
	 * M&eacute;todo que permite realizar la edicin de una instancia de tipo
	 * usuario de la base de datos
	 * 
	 * @param usuario Instancia de tipo usuario que contiene la nueva informacin a guardar
	 */
	public void editUser(Usuario usuario);

}
