package co.edu.udea.ingweb.inventariomoduloii.dao.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;

import co.edu.udea.ingweb.inventariomoduloii.dao.DAOAlertaCreada;
import co.edu.udea.ingweb.inventariomoduloii.model.AlertaCreada;

/**
 * 
 * @author Yefry Alexis Calder&oacute;n Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 * 
 *          Clase que implementa los metodos de la interfaz DAOAlertaCreada
 *
 */
public class DAOAlertaCreadaImpl implements DAOAlertaCreada {

	private static Logger logger = Logger.getLogger(DAOAlertaCreadaImpl.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.dao.DAOAlertaCreada#getCreatedAlerts
	 * ()
	 */
	@Override
	public List<AlertaCreada> getCreatedAlerts() {

		Session session = HibernateUtil.getSessionFactory().openSession();
		List<AlertaCreada> alertasEncontradas = new ArrayList<AlertaCreada>();

		try {
			alertasEncontradas = session.createQuery("from AlertaCreada")
					.list();
		} catch (HibernateException e) {
			logger.debug("Excepcin obteniendo alertas"
					+ e.getLocalizedMessage());
		}
		return alertasEncontradas;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.dao.DAOAlertaCreada#getCreatedAlert
	 * (int)
	 */
	@Override
	public AlertaCreada getCreatedAlert(int idAlertaCreada) {

		Session session = HibernateUtil.getSessionFactory().openSession();
		AlertaCreada alertaEncontrada = null;

		try {
			alertaEncontrada = (AlertaCreada) session.get(AlertaCreada.class,
					idAlertaCreada);
		} catch (HibernateException e) {
			logger.debug("Excepcin obteniendo alertaCreada"
					+ e.getLocalizedMessage());
		}

		return alertaEncontrada;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.dao.DAOAlertaCreada#saveCreatedAlert
	 * (co.edu.udea.ingweb.inventariomoduloii.model.AlertaCreada)
	 */
	@Override
	public void saveCreatedAlert(AlertaCreada alertaCreada) {

		Session session = HibernateUtil.getSessionFactory().openSession();
		session.beginTransaction();

		try {
			session.save(alertaCreada);
			session.beginTransaction().commit();

		} catch (HibernateException e) {
			logger.debug("Excepcin guardando alertas"
					+ e.getLocalizedMessage());
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.dao.DAOAlertaCreada#deleteCreatedAlert
	 * (co.edu.udea.ingweb.inventariomoduloii.model.AlertaCreada)
	 */
	@Override
	public void deleteCreatedAlert(AlertaCreada alertaCreada) {

		Session session = HibernateUtil.getSessionFactory().openSession();
		session.beginTransaction();

		try {
			session.delete(alertaCreada);
			session.beginTransaction().commit();
		} catch (HibernateException e) {
			logger.debug("Excepcin eliminando alertaCreada: "
					+ e.getLocalizedMessage());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.dao.DAOAlertaCreada#editCreatedAlert
	 * ()
	 */
	@Override
	public void editCreatedAlert(AlertaCreada alertaCreada) {
		
		Session session = HibernateUtil.getSessionFactory().openSession();
		session.beginTransaction();
		
		try {
			session.merge(alertaCreada);
			session.beginTransaction().commit();
		} catch (HibernateException e) {
			logger.debug("Excepcin editando alertaCreada: "
					+ e.getLocalizedMessage());
		}
		
	}

}
