package co.edu.udea.ingweb.inventariomoduloii.dao.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;

import co.edu.udea.ingweb.inventariomoduloii.dao.DAOUser;
import co.edu.udea.ingweb.inventariomoduloii.model.Usuario;

/**
 * 
 * @author Yefry Alexis Caldern Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 * 
 *  Clase que implementa todos los m&eacute;todos de la Interfaz
 *  DAOUser
 */
public class DAOUserImp implements DAOUser {

	private static Logger logger = Logger.getLogger(DAOUserImp.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.hibernate.dao.DAOUser#getUsers()
	 */
	@Override
	public List<Usuario> getUsers() {

		Session session = HibernateUtil.getSessionFactory().openSession();
		List<Usuario> usuariosEncontrados = new ArrayList<Usuario>();

		try {

			usuariosEncontrados = session.createQuery("from Usuario").list();

		} catch (HibernateException e) {

			logger.debug("Excepcin obteniendo todos los usuarios: "
					+ e.getLocalizedMessage());
		} finally {
			session.close();
		}

		return usuariosEncontrados;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.hibernate.dao.DAOUser#getUser(int)
	 */
	@Override
	public Usuario getUser(int id) {

		Session session = HibernateUtil.getSessionFactory().openSession();
		Usuario usuarioEncontrado = null;

		try {
			usuarioEncontrado = (Usuario) session.get(Usuario.class, id);
		} catch (HibernateException ex) {
			logger.debug("Excepcin obteniendo usuario: "
					+ ex.getLocalizedMessage());
		} finally {
			session.close();
		}

		return usuarioEncontrado;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.hibernate.dao.DAOUser#saveUser(
	 * co.edu.udea.ingweb.inventariomoduloii.hibernate.model.User)
	 */
	@Override
	public void saveUser(Usuario user) {

		Session session = HibernateUtil.getSessionFactory().openSession();
		session.beginTransaction();

		try {
			session.save(user);
			session.getTransaction().commit();
		} catch (HibernateException e) {
			logger.debug("Excepcin guardando usuario: "
					+ e.getLocalizedMessage());
		} finally {
			session.close();
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.hibernate.dao.DAOUser#deleteUser
	 * (co.edu.udea.ingweb.inventariomoduloii.hibernate.model.User)
	 */
	@Override
	public void deleteUser(Usuario user) {
		Session session = HibernateUtil.getSessionFactory().openSession();
		session.beginTransaction();

		try {
			session.delete(user);
			session.beginTransaction().commit();
		} catch (HibernateException e) {
			logger.debug("Excepcin eliminando usuario: "
					+ e.getLocalizedMessage());
		} finally {
			session.close();
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * co.edu.udea.ingweb.inventariomoduloii.hibernate.dao.DAOUser#editUser(
	 * co.edu.udea.ingweb.inventariomoduloii.hibernate.model.User)
	 */
	@Override
	public void editUser(Usuario user) {
		Session session = HibernateUtil.getSessionFactory().openSession();
		session.beginTransaction();

		try {
			session.merge(user);
			session.beginTransaction().commit();
		} catch (HibernateException e) {
			logger.debug("Excepcin editando usuario: "
					+ e.getLocalizedMessage());
		} finally {
			session.close();
		}

	}

}
