package co.edu.udea.ingweb.inventariomoduloii.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * 
 * @author Yefry Alexis Caldern Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 *
 *          Clase que representa una alerta generada dentro de la base de datos
 */
public class AlertaGenerada implements java.io.Serializable {

	private int idAlertaGenerada;
	private Usuario usuario;
	private Date fecha;
	private String producto;
	private int cantidadProducto;
	private Set alertaGeneradaHasProductos = new HashSet(0);

	public AlertaGenerada() {
	}

	public AlertaGenerada(int idAlertaGenerada, Usuario usuario, Date fecha,
			String producto, int cantidadProducto) {
		this.idAlertaGenerada = idAlertaGenerada;
		this.usuario = usuario;
		this.fecha = fecha;
		this.producto = producto;
		this.cantidadProducto = cantidadProducto;
	}

	public AlertaGenerada(int idAlertaGenerada, Usuario usuario, Date fecha,
			String producto, int cantidadProducto,
			Set alertaGeneradaHasProductos) {
		this.idAlertaGenerada = idAlertaGenerada;
		this.usuario = usuario;
		this.fecha = fecha;
		this.producto = producto;
		this.cantidadProducto = cantidadProducto;
		this.alertaGeneradaHasProductos = alertaGeneradaHasProductos;
	}

	public int getIdAlertaGenerada() {
		return this.idAlertaGenerada;
	}

	public void setIdAlertaGenerada(int idAlertaGenerada) {
		this.idAlertaGenerada = idAlertaGenerada;
	}

	public Usuario getUsuario() {
		return this.usuario;
	}

	public void setUsuario(Usuario usuario) {
		this.usuario = usuario;
	}

	public Date getFecha() {
		return this.fecha;
	}

	public void setFecha(Date fecha) {
		this.fecha = fecha;
	}

	public String getProducto() {
		return this.producto;
	}

	public void setProducto(String producto) {
		this.producto = producto;
	}

	public int getCantidadProducto() {
		return this.cantidadProducto;
	}

	public void setCantidadProducto(int cantidadProducto) {
		this.cantidadProducto = cantidadProducto;
	}

	public Set getAlertaGeneradaHasProductos() {
		return this.alertaGeneradaHasProductos;
	}

	public void setAlertaGeneradaHasProductos(Set alertaGeneradaHasProductos) {
		this.alertaGeneradaHasProductos = alertaGeneradaHasProductos;
	}

}
