package co.edu.udea.ingweb.inventariomoduloii.model;

import java.util.HashSet;
import java.util.Set;

/**
 * 
 * @author Yefry Alexis Caldern Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 *
 *          Clase que representa un Usuario dentro de la base de datos
 */
public class Usuario implements java.io.Serializable {

	private int cedula;
	private String nombre;
	private String rol;
	private String email;
	private String usuario;
	private String contrasena;
	private Set alertaGeneradas = new HashSet(0);
	private Set alertaCreadas = new HashSet(0);

	public Usuario() {
	}

	public Usuario(int cedula, String nombre, String rol, String email,
			String usuario, String contrasena) {
		this.cedula = cedula;
		this.nombre = nombre;
		this.rol = rol;
		this.email = email;
		this.usuario = usuario;
		this.contrasena = contrasena;
	}

	public Usuario(int cedula, String nombre, String rol, String email,
			String usuario, String contrasena, Set alertaGeneradas,
			Set alertaCreadas) {
		this.cedula = cedula;
		this.nombre = nombre;
		this.rol = rol;
		this.email = email;
		this.usuario = usuario;
		this.contrasena = contrasena;
		this.alertaGeneradas = alertaGeneradas;
		this.alertaCreadas = alertaCreadas;
	}

	public int getCedula() {
		return this.cedula;
	}

	public void setCedula(int cedula) {
		this.cedula = cedula;
	}

	public String getNombre() {
		return this.nombre;
	}

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	public String getRol() {
		return this.rol;
	}

	public void setRol(String rol) {
		this.rol = rol;
	}

	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getUsuario() {
		return this.usuario;
	}

	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}

	public String getContrasena() {
		return this.contrasena;
	}

	public void setContrasena(String contrasena) {
		this.contrasena = contrasena;
	}

	public Set getAlertaGeneradas() {
		return this.alertaGeneradas;
	}

	public void setAlertaGeneradas(Set alertaGeneradas) {
		this.alertaGeneradas = alertaGeneradas;
	}

	public Set getAlertaCreadas() {
		return this.alertaCreadas;
	}

	public void setAlertaCreadas(Set alertaCreadas) {
		this.alertaCreadas = alertaCreadas;
	}

}
