package co.edu.udea.ingweb.inventariomoduloii.test;

import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.List;

import org.junit.Test;

import co.edu.udea.ingweb.inventariomoduloii.dao.impl.DAOUserImp;
import co.edu.udea.ingweb.inventariomoduloii.model.Usuario;

/**
 * 
 * @author Yefry Alexis Calder&oacute;n Yepes
 * @author Daniela Serna Buitrago
 * @version 1.0
 * 
 *          Clase que permite realizar pruebas sobre el modelo Usuario de la
 *          Base de Datos
 */

public class DAOUserImpTest {

	private DAOUserImp daoUserImp;

	/**
	 * Prueba al m&eacute;todo obtener usuarios de la base de datos de la clase
	 * DAOUserImp
	 */
	@Test
	public void testGetUsers() {
		daoUserImp = new DAOUserImp();

		List<Usuario> usuariosEncontrados = daoUserImp.getUsers();

		System.out.println("Existes " + usuariosEncontrados.size()
				+ "Usuarios en la Base de datos");

		for (Usuario usario : usuariosEncontrados) {
			System.out.println("cedula: " + usario.getCedula() + " nombre: "
					+ usario.getNombre() + " rol: " + usario.getRol());
		}

		assertNotEquals(usuariosEncontrados.size(), 0);
	}

	/**
	 * Prueba m&eacte;todo obtener usuario a partir de la cedula de la clase
	 * DAOUserImp
	 */
	@Test
	public void testGetUser() {
		this.daoUserImp = new DAOUserImp();

		// Usuario user = daoUsuarioImp.obtenerUsuario(123456);
		// System.out.println("Nombre: " + user.getNombre() + " cedula: " +
		// user.getCedula());

		assertNotNull(daoUserImp.getUser(11111));
	}

	/**
	 * Prueba al m&eacute;todo guardar usuario en la base de datos, de la clase
	 * DAOUserImp
	 */
	@Test
	public void testSaveUser() {
		this.daoUserImp = new DAOUserImp();

		Usuario user = new Usuario();
		user.setEmail("newUser@user.com");
		user.setCedula(11111);
		user.setNombre("alexis");
		user.setContrasena("alexis");
		user.setRol("Usuario");
		user.setUsuario("alexis");

		daoUserImp.saveUser(user);
	}

	/**
	 * Prueba al m&eacute;todo eliminar usuario de la base de datos a partir de
	 * la clave primaria cedula, de la clase DAOUserImp
	 */
	@Test
	public void testDeleteUser() {
		this.daoUserImp = new DAOUserImp();
		Usuario user = daoUserImp.getUser(1);
		this.daoUserImp.deleteUser(user);
	}

	/**
	 * Prueba al m&eacute;todo editar la informaci&oacute;n de un usuario
	 * existente en la base de datos de la clase DAOUserImp
	 */
	@Test
	public void testEditUser() {
		this.daoUserImp = new DAOUserImp();
		Usuario user = daoUserImp.getUser(11111);
		user.setNombre("Farley");
		daoUserImp.editUser(user);
	}

}
