/*
 * Point3D.java
 *
 * Created on November 26, 2007, 2:59 PM
 *
 */

package core;

import ui.AnimationCanvas;

/**
 *
 * @author Suraj Sapktoa [ ssapkota<at>gmail<dot>com ]
 * @version $Id:$
 */
public class Point3D {
    private AnimationCanvas ac=null;
    //world coordinate
    private float x,y,z;
    private float px,py,pz;
    private int dx,dy;
    private boolean projected;
    private boolean moved;
    
    public void move(float dx){
        this.move(dx,0);
    }
    //moves this point by distance dx and dy
    public void move(float dx,float dz){
        if(this.isMoved()){
            return;
        }
        this.x+=dx;
        this.z+=dz;
        this.setMoved(true);
    }
    
    /**
     * Creates a new instance of Point3D
     */
    public Point3D() {
        this.x=0.0F;
        this.y=0.0F;
        this.z=0.0F;
        this.projected=false;
    }
    
    public Point3D(AnimationCanvas ac, float x, float y, float z) {
        this.ac=ac;
        this.x=x;
        this.y=y;
        this.z=z;
        this.projected=false;
    }

    public double getDistance(Point3D p){
        return Math.sqrt(Math.pow((this.getX()-p.getX()),2)+Math.pow((this.getY()-p.getY()),2)+Math.pow((this.getZ()-p.getZ()),2));
    }
    
    public float getX() {
        return x;
    }

    public float getY() {
        return y;
    }
    
    public float getZ() {
        return z;
    }
    
    public void project(){
        if(this.isProjected()){
            return;
        }
        
        float[] a=new float[1],b=new float[1],c=new float[1];
        a[0]=x;
        b[0]=y;
        c[0]=z;
        ac.graphicsPipeLine(a,b,c,1);
        this.px=a[0];
        this.py=b[0];
        this.pz=c[0];
        ac.transformToImageSpace(a,b,c,1);
        this.dx=(int)a[0];
        this.dy=(int)b[0];
        this.setProjected(true);
    }
    public String toString(){
        return new String("World Coordinate: ("+this.getX()+", "+this.getY()+", "+this.getZ()+")");
        //return new String("("+px+","+py+","+pz+")");
    }

    public boolean isProjected() {
        return projected;
    }

    public void setProjected(boolean projected) {
        this.projected = projected;
    }
    
    public void setMoved(boolean moved) {
        this.moved = moved;
    }
    
    public boolean isMoved() {
        return moved;
    }

    /**Projected X-value
     */
    public float getPx() {
        return px;
    }

    /**Projected Y-value
     */
    public float getPy() {
        return py;
    }

    /**Projected Z-value
     */
    public float getPz() {
        return pz;
    }

    /**Device X-value
     */
    public int getDx() {
        return dx;
    }

    /**Device Y-value
     */
    public int getDy() {
        return dy;
    }

    public void setAc(AnimationCanvas ac) {
        this.ac = ac;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }
    
    public void setZ(float z) {
        this.z = z;
    }
}
