/*
 * MainPanel.java
 *
 * Created on December 3, 2007, 11:47 AM
 *
 */

package ui;

import core.IRobot;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

/**
 * Main panel that shows animation and the control buttons
 *
 * @author  Abhishek Dutta (adutta.np@gmail.com)
 * @version $Id: MainPanel.java 36 2008-01-06 12:06:25Z thelinuxmaniac $
 */

public class MainPanel extends JPanel implements ActionListener  {
    private AnimationCanvas animationCanvas;
    private ControlPanel controlPanel;
    private Main main;
    
    // thread that handles the animation
    private Thread animThread;

    /** Creates a new instance of MainPanel */
    public MainPanel(Main m) {
        this.main = m;
        initComponents();
    }
    
    private void initComponents() {
        animationCanvas = new AnimationCanvas();
        controlPanel = new ControlPanel(this);
        
        animThread = new Thread(animationCanvas);
        animThread.setName("Animation-Thread");
        animationCanvas.setRedrawCanvas(false);
        animThread.start();
        
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(animationCanvas, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(controlPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(animationCanvas, javax.swing.GroupLayout.DEFAULT_SIZE, 513, Short.MAX_VALUE)
                .addComponent(controlPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE))
                );
    }
    
    public void actionPerformed(ActionEvent e) {
        // pause the canvas drawing thread
        animationCanvas.setRedrawCanvas(false);
        if(e.getActionCommand() == "ViewPoint-Left")    {
            //move view point to the Left
            animationCanvas.calculateCameraPosition(AnimationCanvas.CAMERA_LEFT);
            
        } else if(e.getActionCommand() == "ViewPoint-Right")    {
            // move view point to the Right
            animationCanvas.calculateCameraPosition(AnimationCanvas.CAMERA_RIGHT);
            
        } else if(e.getActionCommand() == "ViewPoint-Up")    {
            // move view point to the Up
            animationCanvas.calculateCameraPosition(AnimationCanvas.CAMERA_UP);
            
        } else if(e.getActionCommand() == "ViewPoint-Down")    {
            // move view point to the Down
            animationCanvas.calculateCameraPosition(AnimationCanvas.CAMERA_DOWN);
            
        } else if(e.getActionCommand() == "ViewPoint-Plus")    {
            // move view point nearer
            animationCanvas.calculateCameraPosition(AnimationCanvas.CAMERA_IN);
        } else if(e.getActionCommand() == "ViewPoint-Minus")    {
            // move view point farther
            animationCanvas.calculateCameraPosition(AnimationCanvas.CAMERA_OUT);
        } 
        else if(e.getActionCommand() == "ControlPanel-Draw")    {
            // draw the iRobot
            animationCanvas.setRedrawCanvas(true);
            
        } else if(e.getActionCommand() == "ControlPanel-Walk")    {
            // start the animation
            animationCanvas.getRobot().setRobotWalking(true);
            animationCanvas.setRedrawCanvas(false);
            ((JButton) e.getSource()).setText("Stop");
            ((JButton) e.getSource()).setContentAreaFilled(true);
            ((JButton) e.getSource()).setBackground(Color.LIGHT_GRAY);
            ((JButton) e.getSource()).setActionCommand("ControlPanel-Stop");
            ((JButton) e.getSource()).setMnemonic('t');
        } else if(e.getActionCommand() == "ControlPanel-Stop")    {
            // stop the animation
            animationCanvas.getRobot().setRobotWalking(false);
            animationCanvas.setRedrawCanvas(false);
            ((JButton) e.getSource()).setText("Walk");
            ((JButton) e.getSource()).setContentAreaFilled(false);
            ((JButton) e.getSource()).setMnemonic('w');
            ((JButton) e.getSource()).setActionCommand("ControlPanel-Walk");
            controlPanel.getRestartWalkButton().setEnabled(true);
        }else if(e.getActionCommand() == "ControlPanel-RestartWalk")    {
            ((JButton) e.getSource()).setEnabled(false);
            // restart the walking action
            animationCanvas.getRobot().setDestroyRobot(true);
            animationCanvas.setFrame(-100);
            animationCanvas.initParameters();
            animationCanvas.setRobot(new IRobot(animationCanvas));
            animationCanvas.getRobot().setWalkingSpeed(Integer.parseInt(getControlPanel().getWalkSpeedField().getText())*100);
            animationCanvas.setRobotThread(new Thread(animationCanvas.getRobot()));
            animationCanvas.getRobotThread().start();
        }else if(e.getActionCommand() == "ControlPanel-Exit")    {
            // move view point to the Down
            animationCanvas.getRobot().setDestroyRobot(true);
            animationCanvas.setRunAnimation(false);
            while(animThread.getState() != java.lang.Thread.State.TERMINATED);
            main.getFrame().dispose();
        }
        // release the canvas drawing thread
        animationCanvas.setRedrawCanvas(true);
    }

    public AnimationCanvas getAnimationCanvas() {
        return animationCanvas;
    }

    public Main getMain() {
        return main;
    }

    public ControlPanel getControlPanel() {
        return controlPanel;
    }
}
