/*
 * ViewPointControlPanel.java
 *
 * Created on December 4, 2007, 9:47 AM
 *
 */

package ui;

import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JPanel;

/**
 * The four arrow buttons that allows control of the view point
 *
 * @author  Abhishek Dutta (adutta.np@gmail.com)
 * @version $Id: ViewPointControlPanel.java 6 2007-12-04 15:40:50Z thelinuxmaniac $
 */

public class ViewPointControlPanel extends JPanel   {
    // reference to main panel
    private MainPanel mainPanel;
    
    // buttons to control the position of View Point(vp)
    private JButton vpLeft;
    private JButton vpRight;
    private JButton vpUp;
    private JButton vpDown;
    
    /** Creates a new instance of ViewPointControlPanel */
    public ViewPointControlPanel(MainPanel mp) {
        this.mainPanel = mp;
        
//        setBackground(new java.awt.Color(242, 242, 242));
        setBackground(new java.awt.Color(255, 255, 255));
        setMaximumSize(new java.awt.Dimension(120, 80));
        setMinimumSize(new java.awt.Dimension(120, 80));
        setPreferredSize(new java.awt.Dimension(120, 80));
        initComponents();
    }
    
    private void initComponents() {
        vpLeft = new JButton();
        vpLeft.setIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/arrow_left.png")));
        vpLeft.setRolloverIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/arrow_left_roll.png")));
        vpLeft.setMnemonic('l');
        vpLeft.setActionCommand("ViewPoint-Left");
        vpLeft.setToolTipText("Move View Point to LEFT");
        vpLeft.setBorderPainted(false);
        vpLeft.setContentAreaFilled(false);
        vpLeft.setRolloverEnabled(true);
        vpLeft.setMinimumSize(new Dimension(29,21));
        vpLeft.setPreferredSize(new Dimension(29,21));
        vpLeft.addActionListener(mainPanel);

        vpRight = new JButton();
        vpRight.setIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/arrow_right.png")));
        vpRight.setRolloverIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/arrow_right_roll.png")));
        vpRight.setMnemonic('r');
        vpRight.setActionCommand("ViewPoint-Right");
        vpRight.setToolTipText("Move View Point to RIGHT");
        vpRight.setBorderPainted(false);
        vpRight.setContentAreaFilled(false);
        vpRight.setRolloverEnabled(true);
        vpRight.setMinimumSize(new Dimension(29,21));
        vpRight.setPreferredSize(new Dimension(29,21));
        vpRight.addActionListener(mainPanel);
        
        vpUp = new JButton();
        vpUp.setIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/arrow_up.png")));
        vpUp.setRolloverIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/arrow_up_roll.png")));
        vpUp.setMnemonic('u');
        vpUp.setActionCommand("ViewPoint-Up");
        vpUp.setToolTipText("Move View Point to UP");
        vpUp.setBorderPainted(false);
        vpUp.setContentAreaFilled(false);
        vpUp.setRolloverEnabled(true);
        vpUp.setMinimumSize(new Dimension(21,29));
        vpUp.setPreferredSize(new Dimension(21,29));
        vpUp.addActionListener(mainPanel);
        
        vpDown = new JButton();
        vpDown.setIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/arrow_down.png")));
        vpDown.setRolloverIcon(new javax.swing.ImageIcon(getClass().getClassLoader().getResource("resources/images/arrow_down_roll.png")));
        vpDown.setMnemonic('d');
        vpDown.setActionCommand("ViewPoint-Down");
        vpDown.setToolTipText("Move View Point to DOWN");
        vpDown.setBorderPainted(false);
        vpDown.setContentAreaFilled(false);
        vpDown.setRolloverEnabled(true);
        vpDown.setMinimumSize(new Dimension(21,29));
        vpDown.setPreferredSize(new Dimension(21,29));
        vpDown.addActionListener(mainPanel);
        this.add(vpLeft);
        
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(vpLeft, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(20, 20, 20)
                        .addComponent(vpRight, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(47, 47, 47)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(vpUp, javax.swing.GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE)
                            .addComponent(vpDown, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 22, Short.MAX_VALUE)))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(vpUp)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(vpRight)
                    .addComponent(vpLeft))
                .addComponent(vpDown))
        );
    }
}
