package no.ntnu.it1901.resturant.Objecter;

import java.sql.DriverManager;
import java.text.Collator;
import java.util.Locale;

import no.ntnu.it1901.resturant.database.Customer;

/**
 * managing Coustomers to make it easier to handle the information from the database
 * 
 * @author Glover
 * @author Arnfinn
 * @version 1.71 12.11.2010
 * @since java 1.6
 *
 */

public class CustomerOb implements Comparable{
	String fornavn = "NOFORNAME";
	String etternavn = "NOSURNAME";
	String adresse = "NOADDRESS";
	String telefon = "NOTELEPHONE";
	int postnummer = -1;
	String poststed = "NOPLACE";
	int kundeId = -1;
	
//----------------------------CONSTRUCTORS-------------------------------	
	/**
	 * 
	 * @param fornavn fornavn til kunden du vil legge til i databasen
	 * @param etternavn etternavnet til kunden du vil legge til i databasen
	 * @param adresse adresse til kunden du vil legge til i databasen
	 * @param telefon telefon til kunden du vil legge til i databasen
	 * @param postnummer postnummer til kunden du vil legge til i databasen
	 */
	public CustomerOb(String fornavn, String etternavn, String adresse, String telefon, String poststed, int postnummer, int kundeIDFake){
		this.fornavn = fornavn;
		this.etternavn = etternavn;
		this.adresse = adresse;
		this.telefon = telefon;
		this.poststed = poststed;
		this.postnummer = postnummer;
		this.kundeId = kundeIDFake;
	}
	/**

	 * 
	 * Creates a CoustomerObject by getting the information through the database 
	 * by using the coustomer id; kunde_id
	 * 
	 * @param kundeId
	 */
	
	public CustomerOb(int kundeId){
		CustomerOb temp = Customer.createCustomerObject(kundeId);
		this.fornavn = temp.fornavn;
		this.etternavn = temp.etternavn;
		this.adresse = temp.adresse;
		this.telefon = temp.telefon;
		this.poststed = temp.poststed;
		this.postnummer = temp.postnummer;
		this.kundeId = kundeId;
	}
	/**
	 * creates a CustomerOb without kundeId
	 * 
	 * @param fornavn
	 * @param etternavn
	 * @param adresse
	 * @param telefon
	 * @param poststed
	 * @param postnummer
	 */
	public CustomerOb(String fornavn, String etternavn, String adresse, String telefon, String poststed, int postnummer){
		this.fornavn = fornavn;
		this.etternavn = etternavn;
		this.adresse = adresse;
		this.telefon = telefon;
		this.poststed = poststed;
		this.postnummer = postnummer;
		}
	
	
	
	
	
//----------------------Overridden methods----------------------
	/**
	 * toString method that returns the name surname and phone number.
	 * 
	 * @return fornavnet, etternavnet og telefonnummeret til kundeobjektet.
	 */	
	public String toString (){
		return fornavn + " " + etternavn + ", " + telefon;
	}
	
	
	/**
	 * sorts customers in alfabetical order by last name then first name.
	 * 
	 * @param kunder a array of customer object to be sorted
	 * @return Customer sorted array (by etternavn(surname))
	 */

	
	
	public static CustomerOb[] SorterKunder(CustomerOb[] kunder) {
		java.util.Arrays.sort(kunder);
		return kunder;
	}
	
	/**
	 * Implemented method for sorting
	 * 
	 * @see Comparable.compareTo
	 * @param kunde1
	 * @return int -1 0 eller 1
	 */
	
	
	public int compareTo(Object kunde1) {
		Collator col = Collator.getInstance(Locale.getDefault());
		int result = col.compare(this.etternavn,(((CustomerOb) kunde1).etternavn));
		if (result == 0) {
			result = col.compare(this.fornavn,(((CustomerOb) kunde1).fornavn));
		}
		return result;
	}
	
	//------------------------Getters------------------------
	
	public String getFornavn() {
		return fornavn;
	}
	public String getEtternavn() {
		return etternavn;
	}
	public String getAdresse() {
		return adresse;
	}
	public String getTelefon() {
		return telefon;
	}
	public int getPostnummer() {
		return postnummer;
	}
	public String getPoststed() {
		return poststed;
	}
	public int getKundeId() {
		return kundeId;
	}
	public void setFornavn(String fornavn) {
		this.fornavn = fornavn;
	}
	public void setEtternavn(String etternavn) {
		this.etternavn = etternavn;
	}
	public void setAdresse(String adresse) {
		this.adresse = adresse;
	}
	public void setTelefon(String telefon) {
		this.telefon = telefon;
	}
	public void setPostnummer(int postnummer) {
		this.postnummer = postnummer;
	}
	public void setPoststed(String poststed) {
		this.poststed = poststed;
	}
	public void setKundeId(int kundeId) {
		this.kundeId = kundeId;
	}
}
