package no.ntnu.it1901.resturant.UI.Chef;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.Objecter.OrderOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.database.Customer;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * This class creates a panel, with a border,
 * It tells the chef which orders are ready to be cooked,
 * includes extended information on picked order,
 * ability to remember orders the chef are working on
 * buttons to refresh and tell database to mark picked order as done.
 * 
 * @author Jonas
 */
public class ChefPanel extends JPanel implements PanelAdjustment, ListSelectionListener, ActionListener {
	
	//parent panel
	MainGUI gui;
	
	//The buttons used
	JButton bMarkedUnderProgress;
	JButton bMarkedDone;
	public static JButton bRefresh;
	
	//The texts for the buttons
	final static String sMarkedUnderProgress = "Merk som aktiv";
	final static String sMarkedDone = "Merk som ferdig";
	final static String sRefresh = "Oppdater";
	
	
	JTextArea orderInfo;
	JList orders;
	JList ordersUnderProgress;
	JScrollPane ordersScroll;
	JScrollPane ordersUnderProgressScroll;
	
	int pickedItem = 0;
	int bestillingId = 0;
	String sBorderTitle = "Velg Ordre";
	
	//opcodes for the controller
	public final static int COMPLETE_CHEF 		= 3300;
	public final static int GET_UFERDIGE_ORDERS = 3301;

	public static Object[] chefOrder = null;
	Object[] chefOrderUnderProgressArray = null;
	ArrayList<Object> chefOrderUnderProgress = new ArrayList<Object>();
	ArrayList<Integer> pickedItemThinker2 = new ArrayList<Integer>();

	/**
	* Initiates the DeliveryPanel and its subPanels DeliveryMapPanel, DeliveryOrderPanel
	*
	* @param gui
	*/
	public ChefPanel(MainGUI gui) {
		this.gui = gui;
		
		setBackground(Color.RED);
				
		//Disable the layoutManager
		setLayout(null);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		addComponents();
	}

	private void addComponents() {
		
		//Show a border around panel
		TitledBorder tb = BorderFactory.createTitledBorder(sBorderTitle);
		setBorder(tb);
		
		//initializing list, font, listener and scrollpane
		orders = new JList(new String[] {""});
		orders.setFont(MainGUI.FONT);
		orders.addListSelectionListener(this);
		ordersScroll = new JScrollPane(orders);
		
		//initializing list, font, listener and scrollpane
		ordersUnderProgress = new JList(new String[] {"Sett en bestilling aktiv, s den blir lett  finne igjen"});
		//sets the ordersUnderProgress pane as unusable until it is filled with an actual value
		ordersUnderProgress.setEnabled(false);
		ordersUnderProgress.setFont(MainGUI.FONT);
		ordersUnderProgress.addListSelectionListener(this);
		ordersUnderProgressScroll = new JScrollPane(ordersUnderProgress);
		
		//initializing textare, font and if it can be editet or not
		orderInfo = new JTextArea("Velg en bestilling for  f informasjon");
		Font f = new Font(MainGUI.FONT.getFontName(), MainGUI.FONT.getStyle(), (int)(MainGUI.FONT.getSize()*1.4));
		orderInfo.setFont(f);
		orderInfo.setEditable(false);
		
		//initializing buttons and listener
		bMarkedUnderProgress = new JButton(sMarkedUnderProgress);
		bMarkedUnderProgress.addActionListener(this);
		
		bMarkedDone = new JButton(sMarkedDone);
		bMarkedDone.addActionListener(this);
		
		bRefresh = new JButton(sRefresh);
		bRefresh.addActionListener(this);

		//Can't be clicked until you choose an element from a list
		bMarkedDone.setEnabled(false);
		bMarkedUnderProgress.setEnabled(false);
		
		//Adding elements to panel
		add(ordersScroll);
		add(ordersUnderProgressScroll);
		add(orderInfo);
		add(bMarkedUnderProgress);
		add(bMarkedDone);
		add(bRefresh);
		
		//Filling chefOrder array
		gui.notifyController(GET_UFERDIGE_ORDERS, 0);
		//setting cefOrderUnderProgress array after chefOrder is set
		chefOrderUnderProgressArray = new Object[chefOrder.length];
		//Show chefOrder in the prime list
		orders.setListData(chefOrder);
		
	}
	
	/**
	 * List listener for both JList, sets pickedItem to the index of picked order,
	 * 
	 * @param e
	 */
	public void PickedCustomer(ListSelectionEvent e) {
		if(e.getValueIsAdjusting()){ //Picks costumer on click and not on release of click
			pickedItem = ((JList)e.getSource()).getSelectedIndex();
			PrintLine.println("Selected item in ChefPanel: " + pickedItem);
		}
		
	}


	/**
	* When JFrame resizes it sends the new size for this JPanel,
	* this panel also sends the new size for children panels,
	* use it manage scaling of the panel and sub panels
	* @param width
	* @param height
	*/
	public void resizePanel(int width, int height) {
		int vGap = 15;	//Vertical space between elements
		int borderSpace = 15;//To easy let border display
		int buttonHeight = 100;
		double sizeHeight6 = height*0.6;
		double sizeHeight4 = height*0.4;
		System.out.println(sizeHeight6);
		
		ordersUnderProgressScroll.setBounds(borderSpace, (int) sizeHeight6 + vGap/2, width/2-borderSpace-vGap/2, (int) sizeHeight4 - borderSpace - vGap/2);
		ordersScroll.setBounds(borderSpace, borderSpace, width/2-borderSpace - vGap/2, (int) sizeHeight6 - borderSpace - vGap/2);
		orderInfo.setBounds(width/2+vGap/2, borderSpace, width/2-borderSpace-vGap/2, height - ((buttonHeight)+(borderSpace*2)));
		bMarkedUnderProgress.setBounds(width/2+vGap/2+width/6*2, height-buttonHeight-borderSpace, width/6-borderSpace-vGap/2, buttonHeight);
		bMarkedDone.setBounds(width/2+vGap/2+width/6, height-buttonHeight-borderSpace, width/6-borderSpace-vGap/2, buttonHeight);
		bRefresh.setBounds(width/2+vGap/2, height-buttonHeight-borderSpace, width/6-borderSpace-vGap/2, buttonHeight);
		
	}

	public void getInfo(){
	}
	
	public void setInfo(){
		
	}
	
	/**
	* List listener for both JList, sets pickedItem to the index of picked order,
	* and tells deliveryPanel who we picked
	*
	* @param e
	*/
	public void valueChanged(ListSelectionEvent e) {
		if(e.getValueIsAdjusting()){ //Picks costumer on click and not on release of click
			pickedItem = ((JList)e.getSource()).getSelectedIndex();
			if ((JList)e.getSource() == orders){
				ordersUnderProgress.clearSelection();
				bestillingId = ((OrderOb)chefOrder[pickedItem]).getBestillingId();
			}
			else if ((JList)e.getSource() == ordersUnderProgress){
				orders.clearSelection();
				bestillingId = ((OrderOb)chefOrderUnderProgress.get(pickedItem)).getBestillingId();
			}
			PrintLine.println("Selected item in DeliveryOrderPanel: " + pickedItem);
			CustomerOb kunde = Customer.createCustomerObject(((OrderOb)chefOrder[pickedItem]).getKundeId());
			String orderString = ((OrderOb)chefOrder[pickedItem]).toString();
			System.out.println(orderString);
			orderString = orderString.replaceAll("--", "\n\t");
			System.out.println(orderString);
			orderInfo.setText(
				  "Order info: \n\t" + orderString
				+ "\n\nKunde info:\t" + kunde.toString()
				+ "\n\nKommentar:\t"+((OrderOb)chefOrder[pickedItem]).getKommentar());
			bMarkedDone.setEnabled(true);
			bMarkedUnderProgress.setEnabled(true);
		}
	}
	
	
	private void UnderProgressIsEmpty(){
		
		if(ordersUnderProgress.getModel().getSize() == 0){
			ordersUnderProgress.setListData(new String[] {"Sett en bestilling aktiv, s den blir lett  finne igjen"});
			ordersUnderProgress.setEnabled(false);
		}else if(ordersUnderProgress.getModel().getElementAt(0).equals("Sett en bestilling aktiv, s den blir lett  finne igjen")){
			ordersUnderProgress.setEnabled(false);
		}else {
			ordersUnderProgress.setEnabled(true);
			
		}
	}
	
	/**
	 * Button listener for refresh, markedUnderProgress and markedDone buttons,
	 * informs deliveryPanel if they are used
	 * 
	 * @param e
	 */
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() instanceof JButton){
			PrintLine.println("Pressed Button in PickedCustomerPanel: " + ((JButton)e.getSource()).getText());
			if(e.getSource() == bMarkedUnderProgress){
				if(!pickedItemThinker2.contains(bestillingId)){
					pickedItemThinker2.add(bestillingId);
					chefOrderUnderProgress.add(chefOrder[pickedItem]);

				}
				ordersUnderProgress.clearSelection();
				orders.clearSelection();
				chefOrderUnderProgressArray = chefOrderUnderProgress.toArray();
				ordersUnderProgress.setListData(chefOrderUnderProgressArray);
				bMarkedDone.setEnabled(false);
				bMarkedUnderProgress.setEnabled(false);
			}
			else if(e.getSource() == bMarkedDone){
				PrintLine.println("Selected button in ChefPanel: " + bMarkedDone);
				
				for(int i = 0; i < pickedItemThinker2.size(); i++){
					if(pickedItemThinker2.get(i) == bestillingId){
						pickedItemThinker2.remove(i);
						chefOrderUnderProgress.remove(i);
					}
				}
				bMarkedDone.setEnabled(false);
				bMarkedUnderProgress.setEnabled(false);
				gui.notifyController(COMPLETE_CHEF, bestillingId);
				gui.notifyController(GET_UFERDIGE_ORDERS, 0);
				orders.setListData(chefOrder);
				chefOrderUnderProgressArray = chefOrderUnderProgress.toArray();
				ordersUnderProgress.setListData(chefOrderUnderProgressArray);
				gui.deliveryPanel.deliveryOrderPanel.newDoneOrder();
			}
			else if(e.getSource() == bRefresh){	
				PrintLine.println("Selected button in ChefPanel: " + bRefresh);
				gui.notifyController(GET_UFERDIGE_ORDERS, 0);
				orders.setListData(chefOrder);
				ordersUnderProgress.clearSelection();
				bMarkedDone.setEnabled(false);
				bMarkedUnderProgress.setEnabled(false);
			}
			else{
				System.err.println("Dont know what to do with JButton in PickedCustomerPanel: " + ((JButton)e.getSource()).getText());
			}
			UnderProgressIsEmpty();
		}	
	}

	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		gui.notifyController(GET_UFERDIGE_ORDERS, 0);
		orders.setListData(chefOrder);
	}
	public void newOrder(){
	PrintLine.println("Selected button in ChefPanel: " + bRefresh);
	gui.notifyController(GET_UFERDIGE_ORDERS, 0);
	orders.setListData(chefOrder);
	ordersUnderProgress.clearSelection();
	bMarkedDone.setEnabled(false);
	bMarkedUnderProgress.setEnabled(false);
	}
}

