package no.ntnu.it1901.resturant.UI.Delivery;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
/**
 * This class displays a map for an address and postcode
 * 
 * The image is gotten from Google Maps, using the static maps API. 
 * The address and postcode are changed by the setLocation method, and the 
 * size by the resize method
 * 
 * @author Jonas
 * @version 1.5
 */
public class DeliveryMapPanel extends JPanel{
	DeliveryPanel deliveryPanel;	//Parent Panel
	int width = 15, height = 15; 	//default height and with of the map
	//used so we get the same pictures after exporting
	ImageIcon defImage;
	ImageIcon errorImage;
	
	JLabel labelImage;
	
	//Address and postcode for use in creating the map
	String address;
	String postcode;
	
	/**
	 * Displays a map in a Panel and changes its
	 * location according to setLocation method.
	 * @param deliveryPanel The panel where the map is placed
	 */
	public DeliveryMapPanel(DeliveryPanel deliveryPanel) { 
		//Parent Panel
		this.deliveryPanel = deliveryPanel;
		
		//used to get the relative address of the images
		ClassLoader cldr = this.getClass().getClassLoader();
		java.net.URL imageURL   = cldr.getResource("img/VelgEnLevering.png");
		if ( imageURL == null){
			imageURL   = cldr.getResource("no/ntnu/it1901/resturant/img/velgEnLevering.png");
		}
		defImage = new ImageIcon(imageURL); //Default image
		
		imageURL   = cldr.getResource("img/AdresseIkkeFunnet.png");
		if (imageURL == null){
			imageURL   = cldr.getResource("no/ntnu/it1901/resturant/img/adresseIkkeFunnet.png");
		}
		errorImage = new ImageIcon(imageURL); 	//Error image
		//Disable layout
		setLayout(null);
		//Sets a default image you can make a map(nothing is selected)
		labelImage = new JLabel(defImage);
		add(labelImage);
		
	}
	
	/**
	 * Makes a Map from the address and postcode of this DeliveryMapPanel
	 */
	private void drawMap() {
		//if Url returns null
		ImageIcon map = errorImage;
		//if there is no address or postcode(nothings been selected)
		if (address == null || postcode == null){
			map = defImage;
		}
		URL url = createURL(address, postcode, width, height);
		//Sets the image to be the map gotten from the URL(Using Google static map)
		if (url != null){
		    Image image = Toolkit.getDefaultToolkit().createImage(url);
		    map = new ImageIcon(image);
		}
		labelImage.removeAll();
		labelImage.setIcon(map);
		labelImage.repaint();
	}
	/**
	 * Receives an address, postCode and town and update map to the new location<br><br>
	 * 
	 * @param address the new address
	 * @param postcode the new postcode
	 */
	public void setLocation(String address, String postcode){
		address = address.replaceAll(" ", "%20");
		postcode = postcode.replaceAll(" ", "%20");
		this.address = address;
		this.postcode = postcode;
		System.out.println("DeliveryMapPanel recived new location. Address: " + address + " PostCode: " + postcode);
		drawMap();
		
	}
	
	/**
	 * When JFrame resizes it sends the new size for this JPanel,
	 * use it to keep the midpoint in the map centered.
	 * @param width the new width
	 * @param height the new height
	 */
	public void resizePanel(int width, int height){
		System.out.println("MapPanel recived new size x=" + width + " and y=" + height);
		this.width = width;
		this.height = height;
		labelImage.setBounds(0,0,width,height);
		drawMap();
		
		
	}
	
	/**
	 * When CreateURL is called, it generates a URL from given information
	 * uses address, postCode, width and height
	 * @param address
	 * @param postcode
	 * @param width
	 */ 
	private URL createURL(String address, String postcode, int ysize , int xsize){
        URL url = null;
        if (postcode == null || address == null){
        	return url;
        }
		if (postcode.equalsIgnoreCase("%20") || address.equalsIgnoreCase("%20")){
			System.out.println("No town/postcode/address");
			return url;
		}else if (postcode.equals("") || address.equals("")){
			System.out.println("No town/postcode/address");
			return url;
		}else{
			try {
	        	String marker = postcode+","+address;
	        	String size = Integer.toString(ysize)+"x"+Integer.toString(xsize);
	        	String urlString = "http://maps.google.com/maps/api/staticmap?size="
	        		+size+"&maptype=roadmap&markers=size:mid|color:red|Norway,Trondheim,ntnu|" +
	        				"&markers=size:mid|color:green|Norway,"
	        		+marker+"&sensor=false";
				url = new URL(urlString);
				return url;
			} catch (MalformedURLException e) {
				System.err.println("Error in createURL");
				return null;
			}
		}
		
	}
}
