package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.database.Customer;
import no.ntnu.it1901.resturant.other.PrintLine;
/**
 * PickedCustomerPanel receives the picked Customer from ResultsCustomerPanel.
 * It then allows for editing the Customer element and send changes to database
 * @author ghenrik
 *
 */
public class PickedCustomerPanel extends JPanel implements PanelAdjustment, ActionListener{
	CustomerChooserPanel customerChooserPanel;

	JButton bEditCustomer;
	JTextField tForename, tSurname, tTelephone, tAddress, tPostCode, tTown, tId; //Input from user
	CustomerOb selectedCustomer;
	
	final static String sEditCustomer = "Endre Kunde";
	/**
	 * Initiates the PickedCustomerPanel, sets it's parent panel,
	 * sets layout to null, make the panel background opaque and
	 * adds the JButton and JTextFields.
	 * @param customerChooserPanel
	 */
	public PickedCustomerPanel(CustomerChooserPanel customerChooserPanel) {
		super();
		this.customerChooserPanel = customerChooserPanel;
		
		setBackground(Color.RED);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		
		addComponents();
	}
	
	/**
	 * Add the components to this JPanel
	 */
	private void addComponents(){
		
		bEditCustomer = new JButton(sEditCustomer);
		bEditCustomer.setFont(MainGUI.FONT);
		bEditCustomer.setMargin(new Insets(0, 0, 0, 0));
		bEditCustomer.addActionListener(this);

		tForename = new JTextField();
		tSurname = new JTextField();
		tTelephone = new JTextField();
		tAddress = new JTextField();
		tPostCode = new JTextField();
		tTown = new JTextField();
		tId = new JTextField();
		

		//Font
		tForename.setFont(MainGUI.FONT);
		tSurname.setFont(MainGUI.FONT);
		tTelephone.setFont(MainGUI.FONT);
		tAddress.setFont(MainGUI.FONT);
		tPostCode.setFont(MainGUI.FONT);
		tTown.setFont(MainGUI.FONT);
		tId.setFont(MainGUI.FONT);
		
		//Disable editing of tId
		tId.setEnabled(false);
		
		add(tForename);
		add(tSurname);
		add(tTelephone);
		add(tAddress);
		add(tPostCode);
		add(tTown);
		add(tId);
		
		add(bEditCustomer);
		
	}

//--Get and Set methods
	
	/**
	 * Gives customer element to this Class and fills inn JTextFields<br>
	 * Gives a call to orderPanel to update receipt
	 */
	public void setCustomer(CustomerOb selectedCustomer) {
		this.selectedCustomer = selectedCustomer;
		tForename.setText(selectedCustomer.getFornavn());
		tSurname.setText(selectedCustomer.getEtternavn());
		tTelephone.setText(selectedCustomer.getTelefon());
		tAddress.setText(selectedCustomer.getAdresse());
		tPostCode.setText(String.format("%04d",selectedCustomer.getPostnummer()));
		tTown.setText(selectedCustomer.getPoststed());
		tId.setText(selectedCustomer.getKundeId() + "");
		
		customerChooserPanel.orderPanel.buildReceipt();
	}
	/**
	 * Returns string of selected customer to be used in receipt
	 */
	public String getReciptCustomer(){
		String result = "";
		result += "Fornavn: \t" + tForename.getText() + "\n";
		result += "Etternavn: \t" + tSurname.getText() + "\n";
		result += "Telefon: \t" + tTelephone.getText() + "\n";
		result += "Addresse: \t" + tAddress.getText() + "\n";
		result += "Poststed :\t" + tPostCode.getText() + "\n";
		result += "Hjemsted: \t" + tTown.getText() + "\n";
		return result;
	}
	/**
	 * Returns picked customer, includes database id and changes made to customer
	 * @return the pickedCustomer
	 */
	public CustomerOb getPickedCustomer() {
		try {
			CustomerOb result = new CustomerOb(
					tForename.getText(),
					tSurname.getText(),
					tAddress.getText(),
					tTelephone.getText(),
					tTown.getText(),
					Integer.parseInt(tPostCode.getText()),
					Integer.parseInt(tId.getText()));
			return result;
		} catch (NumberFormatException e) {
			return new CustomerOb("Dummy Customer", "Dont serve this", "", "", "Dont press edit!", 0, -1);
		}
	}
//--End Get and Set methods
	
//--Implemented Methods
	
  //PanelAdjustment
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resizePanel(int width, int height) {
	
		FontMetrics fm = tForename.getFontMetrics(new Font(MainGUI.fontType, Font.BOLD, 15)); 
		
		int textAreaStart = 0;//width/2-20;
		int textHeight = fm.getHeight();
		int space = 5; //Space between TextFields;
		int panning = 5; //Space between JLabel and TextField
		int start = 50;
		int segment = 0;
		

		tForename	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tSurname	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tTelephone	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tAddress	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tPostCode	.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tTown		.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		tId			.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
		bEditCustomer.setBounds(textAreaStart, start + (textHeight+space)*segment++, width-textAreaStart, textHeight);
	}
	
  //ActionListener
	
	public final static int EDIT_CUSTOMER  		= 1400;
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() instanceof JButton){
			PrintLine.println("Pressed Button in PickedCustomerPanel: " + ((JButton)e.getSource()).getText());
			if(e.getSource() == bEditCustomer){
				customerChooserPanel.action(EDIT_CUSTOMER);				
			}
			else{
				System.err.println("Dont know what to do with JButton in PickedCustomerPanel: " + ((JButton)e.getSource()).getText());
			}
		}
		
	}


	


}
