
package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;
/**
 * The ResultCustomerPanel is a subPanel of CustomerChooserPanel<br>
 * <br>
 * It's job is to display results from customer searches in a JList. 
 * @author ghenrik
 *
 */
public class ResultsCustomerPanel extends JPanel implements PanelAdjustment, ListSelectionListener{
	
	//Parent Panel
	CustomerChooserPanel customerChooserPanel;
	
	JList results;
	JScrollPane resultsScroll;
	CustomerOb[] listData;
	int pickedItem = 0; //Item number for the selected element in list;
	boolean firstTime = true;
	/**
	 * Initiates the ResultCustomerPanel, sets it's parent panel,
	 * sets layout to null, make the panel background opaque and
	 * adds the JList inside a JScrollPane.
	 * @param customerChooserPanel
	 */
	public ResultsCustomerPanel(CustomerChooserPanel customerChooserPanel) {
		super();
		
		this.customerChooserPanel = customerChooserPanel;
		setBackground(Color.CYAN);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		                
		addComponents();
	}
	/**
	 * Add the components to this JPanel
	 */	
	private void addComponents() {
		
		results = new JList();
		results.setFont(MainGUI.FONT);
		results.addListSelectionListener(this);
		resultsScroll = new JScrollPane(results);
		add(resultsScroll);
		
	}

//--Get and Set methods
	
	/**
	 * Sets the JList to received customer
	 * If only one customer is received, that customer is automatically picked
	 * and sent to PickedCustomerPanel 
	 */
	public void setResults(CustomerOb[] listData) {
		this.listData = listData;
		this.results.setListData(listData);
		/*
		 * Pick element if its only one to choose from if it's not the first time
		 * fix a bug where the program crash if there is one customer in the database
		 * as you start the system.
		 */
		if(listData.length == 1 && !firstTime){
			results.setSelectedIndex(0);
			pickedItem = 0;
			PrintLine.println("Result is autoselected in ResultsCustomerPanel, picked item nr: " + pickedItem);
			customerChooserPanel.action(PICKED_CUSTOMER);
		} else if (firstTime){
			firstTime = false;
		}
		

		
	}
	/**
	 * Returns the last selected customer
	 * @return Customer Ob
	 */
	public CustomerOb getKunde(){
		
		if(pickedItem >= 0 && listData != null && pickedItem < listData.length){
			return listData[pickedItem];
		}
		System.err.println("Tried to pick an unavailable item out of list in ResultsCustomerPanel, Returned fake Customer");
		return new CustomerOb("Pick a real", "customer, oki?", "", "", "Dont press edit!", 0, -1); //Should I just send null instead? Or just break the program
	}

//--End Get and Set methods
	
//--Implemented Methods
	
  //PanelAdjustment
	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}
	
  
	@Override
	public void resizePanel(int width, int height) {
		resultsScroll.setBounds(0, 0, width, height);
	}
	
	
	//ListSelectionListener
	final static int PICKED_CUSTOMER = 1300;
	@Override
	public void valueChanged(ListSelectionEvent e) {
		if(e.getValueIsAdjusting()){ //Picks costumer on click and not on release of click
			pickedItem = ((JList)e.getSource()).getSelectedIndex();
			PrintLine.println("Selected item in ResultsCustomerPanel: " + pickedItem);
			customerChooserPanel.action(PICKED_CUSTOMER);
		}
		
	}

}
