package no.ntnu.it1901.resturant.UI.Order;

import java.awt.Color;
import java.awt.FontMetrics;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

import no.ntnu.it1901.resturant.UI.MainGUI;
import no.ntnu.it1901.resturant.UI.PanelAdjustment;
import no.ntnu.it1901.resturant.other.PrintLine;

/**
 * The SearchDishPanel is a subPanel of DishChooserPanel<br>
 * <br>
 * It's job is to change the listDishElements[].display to 
 * true or false based on matches in the search result.<br>
 * It then calls repaintPanel in listDishPanel to refresh list.
 * @author ghenrik
 *
 */
public class SearchDishPanel extends JPanel implements PanelAdjustment, DocumentListener{
	
	DishChooserPanel dishChooserPanel;
	
	JTextField searchBar;
	
	JLabel searchDish;
	String sSearchDish = "Sk matrett:";
	/**
	 * Initiates the ResultCustomerPanel, sets it's parent panel,
	 * sets layout to null, make the panel background opaque and
	 * adds the JTextField
	 * @param dishChooserPanel
	 */
	public SearchDishPanel(DishChooserPanel dishChooserPanel) {
		this.dishChooserPanel = dishChooserPanel;

		setBackground(Color.MAGENTA);
		
		//If we want to see the panel border
		setOpaque(MainGUI.viewPanelShapes);
		
		//Disable layout
		setLayout(null);
		
		addComponents();
		
	}
	/**
	 * Add the components to this JPanel
	 */	
	private void addComponents() {
		searchDish = new JLabel(sSearchDish);
		searchDish.setFont(MainGUI.FONT);
		
		searchBar = new JTextField();
		searchBar.getDocument().addDocumentListener(this);
		searchBar.setFont(MainGUI.FONT);
		
		add(searchDish);
		add(searchBar);
	}
	
	/**
	 * When order is completed, reset search
	 */
	public void resetSearch() {
	searchBar.setText("");
		
	}
	//--Get and Set methods

	//--End Get and Set methods

	//--Implemented Methods
	

	@Override
	public void action(int opCode) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void repaintPanel() {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void requestRefresh() {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void resizePanel(int width, int height) {
		FontMetrics fm = searchDish.getFontMetrics(searchDish.getFont());
		
		int padding = 15; //Space between JLabel and JTextField
		int searchDishWidth = fm.stringWidth(sSearchDish);
		int componentHeight = fm.getHeight();
		int searchBarWidth = width - padding - searchDishWidth;
		searchDish.setBounds(0, padding, searchDishWidth, componentHeight);
		searchBar.setBounds(padding+searchDishWidth, padding-5, searchBarWidth, 20);
		
	}

	@Override
	public void changedUpdate(DocumentEvent e) {changedTextField(e);}
	@Override
	public void insertUpdate(DocumentEvent e) {changedTextField(e);}
	@Override
	public void removeUpdate(DocumentEvent e) {changedTextField(e);}
	
	private void changedTextField(DocumentEvent e) {
		String searchString = "";
		try {
			searchString = e.getDocument().getText(0, e.getDocument().getLength());
			PrintLine.println("Document changed in SearchDishPanel: " + searchString);
		} catch (BadLocationException e1) {
			e1.printStackTrace();
		}
		searchString = searchString.toLowerCase();
		ListDishElement[] listDishElements = dishChooserPanel.getListDishElements();
		for (int i = 0; i < listDishElements.length; i++) {
			
			if(listDishElements[i].dish.getRettnavn().toLowerCase().contains(searchString)){
				listDishElements[i].display = true;		
			}
			else{
				listDishElements[i].display = false;
			}
		}	

		dishChooserPanel.repaintPanel();
	}
	
}
