package no.ntnu.it1901.resturant.other;

import java.util.ArrayList;

/**
 * Creates an ascii tree of tree structure in main. Example:<br><br>
 * 
 * JFrame MainGUI<br>
|<br>
|-OrderPanel<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|-CustomerChooserPanel<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|-ManualInputPanel<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|-SearchCustomerPanel<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|-ResultCustomerPanel<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|-PickedCustomerPanel<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|<br>
|&nbsp;&nbsp;&nbsp;&nbsp;|-SearchCustomer<br>
 * @author ghenrik
 *
 */

public class AsciiTree {

	/**
	 * @param args
	 */
	
	public static void main(String[] args) {
		Node[] tree = new Node[40];
		
		for (int i = 0; i < tree.length; i++) {
			tree[i] = new Node();
		}
		
		tree[0].name = "JFrame MainGUI";
		tree[1].name = "OrderPanel";
		tree[2].name = "CustomerChooserPanel";
		tree[3].name = "ManualInputPanel";
		tree[4].name = "SearchCustomerPanel";
		tree[5].name = "ResultCustomerPanel";
		tree[6].name = "PickedCustomerPanel";
		tree[7].name = "SearchCustomer (";
		
		tree[8].name = "DishChooserPanel";
		tree[9].name = "ListDishPanel";
		tree[10].name = "CommentDishPanel";
		tree[11].name = "SearchDishPanel";
		
		tree[12].name = "DeliveryPanel";
		tree[13].name = "DeliveryMapPanel";
		tree[14].name = "DeliveryOrderPanel";
		
		tree[15].name = "ReceiptPanel";
		tree[16].name = "ReceiptResultsPanel";
		tree[17].name = "ReceiptSettingsPanel";
		
		tree[18]. name = "AdminSettingPanel";
		tree[19]. name = "NewDishPanel";
		
		tree[20].name =  "ChefPanel";
		
		
		tree[0].children.add(tree[1]); //Add orderpanel
		tree[0].children.add(tree[12]); //Add DeliveryPanel
		tree[0].children.add(tree[20]); //Add CHefpanel
		tree[0].children.add(tree[18]); //Add AdminSettingPanel
		
		
		tree[1].children.add(tree[2]); //OrderPanel Add subpanels
		tree[1].children.add(tree[7]);
		tree[1].children.add(tree[8]);
		tree[1].children.add(tree[15]);

		tree[2].children.add(tree[3]); //CustomerchooserPanel add subpanels
		tree[2].children.add(tree[4]);
		tree[2].children.add(tree[5]);
		tree[2].children.add(tree[6]);
		

		tree[8].children.add(tree[11]); //DishChooserPanel add subpanels
		tree[8].children.add(tree[9]);
		tree[8].children.add(tree[10]);
		
		tree[15].children.add(tree[16]); //ReceiptPanel add subpanels
		tree[15].children.add(tree[17]);
		
		tree[12].children.add(tree[13]);//DeliveryPanel add subpanels
		tree[12].children.add(tree[14]);
		
		tree[18].children.add(tree[19]);//AdminSettingPanel add subpanels
		
		
		
		
		rec(0,tree[0]);
		
	}
	
	static void rec(int level, Node node){
		
		String line = "";
		
		String space = " ";//"&nbsp";
		String breakln = "";//<br>";
		for(int i = 0; i < level; i++){
			if(level == i+1){
				line += "|" + breakln;		
			}
			else{
				line += "|" + space+space+space+space;
			}

		}
		
		//To avoid an extra printline above rootNode
		if(level > 0){
			System.out.println(line);
		}
		
		//To add a <br> on each line we have to rebuild it
		line = "";
		
		for(int i = 0; i < level; i++){
			if(level == i+1){
				line += "|";		
			}
			else{
				line += "|" + space+space+space+space;
			}

		}
		
		//To avoid an extra "-" in rootNode
		if(level > 0){
			line += "-";
		}
		
		line += node.name + breakln;
		System.out.println(line);
		for(Node current:node.children){
			rec(level+1, current);
		}
		
	}

}
/**
 * Includes name of node and an ArrayList of children of Node;
 * @author ghenrik
 *
 */
class Node{
	String name = "ERR: THIS NODE DONT HAVE A NAME";
	ArrayList<Node> children = new ArrayList<Node>();
}