package no.ntnu.it1901.resturant.search;

import java.util.LinkedList;

import no.ntnu.it1901.resturant.Objecter.CustomerOb;
import no.ntnu.it1901.resturant.other.PrintLine;
/**
 * Recives a Customer[] and search through it every time searchCustomer is called
 * @author ghenrik
 *
 */
public class SearchCustomer {
	
	
	CustomerOb[] customerFull; 		//The entire list of customers
	CustomerOb[] customerResult;	//The list of results taken from customers
	
	/**
	 * Initiates the Search Customer Panel
	 * @param kundeFull
	 */
	public SearchCustomer(CustomerOb[] kundeFull) {
		this.customerFull = kundeFull;
	}
	
	/**
	 * On new customer added to database, retrieve it to insert it to list
	 */
	public void setSingleCustomer(CustomerOb customer){
		CustomerOb[] newList = new CustomerOb[customerFull.length+1];
		for(int i = 0; i < customerFull.length; i++){
			newList[i] = customerFull[i];
		}
		newList[newList.length-1] = customer;
		customerFull = newList;
	}
	
	/**
	 * Search and returns an array of customer based on input strings
	 */
	public CustomerOb[] searchCustomer(String forename, String surname, String address, String telephone, String town, String postcode){
		PrintLine.println("Start search for customer, Manual input");
		forename = forename.toLowerCase().trim();
		surname = surname.toLowerCase().trim();
		address = address.toLowerCase().trim();
		telephone = telephone.toLowerCase().trim();
		town = town.toLowerCase().trim();
		postcode = postcode.toLowerCase().trim();
		
		LinkedList<CustomerOb> results = new LinkedList<CustomerOb>();
		boolean match;
		for (int i = 0; i < customerFull.length; i++) {
			match = true;
			if(forename.length() > 0){
				if(! (customerFull[i].getFornavn().toLowerCase().contains(forename))){ //Checks if match is false
					match = false;
				}
			}
			if(surname.length() > 0){
				if(! (customerFull[i].getEtternavn().toLowerCase().contains(surname))){ //Checks if match is false
					match = false;
				}
			}
			if(address.length() > 0){
				if(! (customerFull[i].getAdresse().toLowerCase().contains(address))){ //Checks if match is false
					match = false;
				}
			}
			if(telephone.length() > 0){
				if(! (customerFull[i].getTelefon().toLowerCase().contains(telephone))){ //Checks if match is false
					match = false;
				}
			}
			if(town.length() > 0){
				if(! (customerFull[i].getPoststed().toLowerCase().contains(town))){ //Checks if match is false
					match = false;
				}
			}
			if(postcode.length() > 0){
				
				//I love String.format now
				String format = "%0" + postcode.length() + "d";
				if(! (String.format(format, customerFull[i].getPostnummer()).contains(postcode))){
					match = false;
				}
			}
			
			//If match stays true all the way, its added to results.
			if(match){
				results.add(customerFull[i]);				
			}
			
		}

		customerResult = new CustomerOb[results.size()];
		
		int i = 0;
		for(CustomerOb c: results){
			customerResult[i] = c;
			i++;
		}
		PrintLine.println("End search for customer, found " + customerResult.length + " matches");
		return customerResult;
	}
	/**
	 * Search and returns an array of customer based on general search
	 */	
	public CustomerOb[] searchCustomer(String generalSearch){
		PrintLine.println("Start search for customer, general search");
		
		generalSearch = generalSearch.toLowerCase();
		
		String customerString;
		
		LinkedList<CustomerOb> results = new LinkedList<CustomerOb>();
		boolean match;
		for (int i = 0; i < customerFull.length; i++) {
			
			customerString = "";
			customerString += customerFull[i].getFornavn().toLowerCase() + " ";
			customerString += customerFull[i].getEtternavn().toLowerCase() + " ";
			customerString += customerFull[i].getAdresse().toLowerCase() + " ";
			customerString += customerFull[i].getTelefon().toLowerCase() + " ";
			customerString += customerFull[i].getPoststed().toLowerCase() + " ";

			String format = "%0" + 4 + "d"; //Postcode of 4. Norwegian standards
			customerString += String.format(format, customerFull[i].getPostnummer());

			if(customerString.contains(generalSearch)){
				results.add(customerFull[i]);	
			}
		}

		customerResult = new CustomerOb[results.size()];
		
		int i = 0;
		for(CustomerOb c: results){
			customerResult[i] = c;
			i++;
		}
		PrintLine.println("End search for customer, found " + customerResult.length + " matches");
		return customerResult;
	}
	
	/**
	 * Edit customer based on CustomerID
	 */
	public void editCustomer(CustomerOb customer){
		for (int i = 0; i < customerFull.length; i++) {
			if(customerFull[i].getKundeId() == customer.getKundeId()){
				customerFull[i] = customer;
			}
		}
		
	}

}
