package rates;


public class VanillaSwap {

	private YieldCurve yieldCurve;

	private SwapCashFlows leg1;

	private SwapCashFlows leg2;

	/** Default constructor : create a vanilla swap with two legs */
	public VanillaSwap(SwapCashFlows cashflowReceived, SwapCashFlows cashflowPaid,
			String name1, String name2, YieldCurve curve) {
		this.leg1 = cashflowReceived;
		this.leg2 = cashflowPaid;
		this.yieldCurve = curve;
	}

	/** Return fair value of first leg */
	public double getFairValue1() {
		return leg1.getFairValue(yieldCurve);
	}

	/** Return fair value of second leg */
	public double getFairValue2() {
		return leg2.getFairValue(yieldCurve);
	}

	/** Return price of the swap */
	public double getPrice() {
		return getFairValue1() - getFairValue2();
	}

	/** Return sensitivity to the interest rate */
	public double getRho() {
		double result = getPrice();
		yieldCurve.shiftZCBRateCurve(YieldCurve.defaultshiftfactorForShortRate);
		result -= getPrice();
		yieldCurve.shiftZCBRateCurve(-1
				* YieldCurve.defaultshiftfactorForShortRate);

		return result;
	}

	/** Return sensitivity to the time */
	public double getTheta() {
		double result = getPrice();
		YieldCurve tmpYieldCurve = new YieldCurve(yieldCurve.getPointsIntheMarketCurve(), yieldCurve.getName());
		yieldCurve = yieldCurve.forwardZCBCurve(1.0 / 365.0);
		result -= getPrice();
		yieldCurve = tmpYieldCurve;
		return result;
	}
}
