package rates;

import common.DayCountConvention;

public final class YieldPoint {

	private final double rate;

	private final double maturity;

	private final TypeOfRate typeOfRate;

	private final DayCountConvention dayCountConvention;

	public YieldPoint() {
		rate = 0.0;
		maturity = 0.0;
		typeOfRate = TypeOfRate.Cash;
		dayCountConvention = DayCountConvention.ACT_360;
	}

	public YieldPoint(double rate, double maturity, TypeOfRate typeOfRate,
			DayCountConvention dayCountConvention) {
		this.rate = rate;
		this.maturity = maturity;
		this.typeOfRate = typeOfRate;
		this.dayCountConvention = dayCountConvention;
	}
	
	public YieldPoint(YieldPoint yp) {
		this(yp.getRate(), yp.getMaturity(),
				yp.getRateType(), yp.getDayCountConvention());
	}

	public YieldPoint(double rate, double maturity, TypeOfRate typeOfRate) {
		this(rate, maturity, typeOfRate, DayCountConvention.ACT_360);
	}

	public double getRate() {
		return rate;
	}

	public double getMaturity() {
		return maturity;
	}

	public TypeOfRate getRateType() {
		return typeOfRate;
	}

	public DayCountConvention getDayCountConvention() {
		return dayCountConvention;
	}
}
