package tests;

import junit.framework.TestCase;
import rates.Bond;
import rates.YieldCurve;
import common.Date;
import common.DayCountConvention;
import common.Frequency;

public class BondTest extends TestCase {
	
	private Date issue;
	private Date maturity;
	private Date firstcoupondate;
	private double coupon;
	private Frequency frequency;
	private double faceamount;
	private DayCountConvention daycount;
	private YieldCurve testcurve;
	private Bond bond;
	
	public void setUp() throws Exception {
		
		issue = new Date(15,11,2005);
		maturity = new Date(15,11,2015);
		firstcoupondate = new Date(15,5,2006);
		coupon = 0.045;
		frequency = Frequency.Semiannual;
		faceamount = 100.0;
		daycount = DayCountConvention.ACT_365;
		testcurve = new YieldCurve(0.05);
		bond = new Bond(issue, maturity, firstcoupondate, coupon, frequency, faceamount, daycount, testcurve);
	}
	
	public void testFairValue() {
		double fairValue = bond.fairValue();
		boolean result = (fairValue >= 95.55) && (fairValue <= 95.65);
		assertTrue(result);
	}
	
	public void testDuration() {
		double duration = bond.duration();
		boolean result = (duration >= 8.10) && (duration <= 8.12);
		assertTrue(result);
	}
	
	public void testConvexity() {
		double convexity = bond.convexity();
		boolean result = (convexity >= 75.05) && (convexity <= 75.10);
		assertTrue(result);
	}
}
