package tests;

import junit.framework.TestCase;

import common.BusinessDayConvention;
import common.Date;

public class DateTest extends TestCase {
	private Date d1;

	private Date d2;

	protected void setUp() throws Exception {
		super.setUp();
		d1 = new Date(01, 06, 2006);
		d2 = new Date(05, 07, 2007);
	}

	public void testWeekday() {
		assertEquals(05, d1.weekday().value());
		assertEquals(05, d2.weekday().value());
	}

	public void testMonth() {
		assertEquals(06, d1.month().value());
		assertEquals(07, d2.month().value());
	}

	public void testYear() {
		assertEquals(2006, d1.year());
		assertEquals(2007, d2.year());
	}

	public void testEquals() {
		assertEquals(false, d1.isEqual(d2));
	}

	public void testIncrement() {
		d1 = d1.increment();
		assertEquals("2/6/2006", d1.toString());
	}

	public void testDecrement() {
		d2 = d2.decrement();
		assertEquals("4/7/2007", d2.toString());
	}

	public void testIsBusinessDay() {
		Date d1 = new Date(26, 5, 2006);
		assertEquals(true, d1.isBusinessDay());
		Date d2 = new Date(27, 5, 2006);
		assertEquals(false, d2.isBusinessDay());
	}

	public void testIsEndOfMonth() {
		Date d1 = new Date(31, 5, 2006);
		assertEquals(true, d1.isEndOfMonth());
		Date d2 = new Date(1, 6, 2006);
		assertEquals(false, d2.isEndOfMonth());
	}

	public void testSetDateToToday() {
		java.util.GregorianCalendar calendar = new java.util.GregorianCalendar();
		int day = calendar.get(java.util.Calendar.DATE);
		int month = calendar.get(java.util.Calendar.MONTH) + 1;
		int year = calendar.get(java.util.Calendar.YEAR);

		Date d1 = Date.setDateToToday();

		assertEquals(d1.dayOfMonth(), day);
		assertEquals(d1.month().value(), month);
		assertEquals(d1.year(), year);
	}

	public void testApplyConvention() {
		Date d1 = new Date(30,4,2006);
		Date d3 = new Date(1,10,2006);
		
		Date d2 = Date.applyConvention(d1, BusinessDayConvention.ModifiedFollowing);
		assertEquals("28/4/2006", d2.toString());
		d2 = Date.applyConvention(d1, BusinessDayConvention.Following);
		assertEquals("1/5/2006", d2.toString());
		d2 = Date.applyConvention(d1, BusinessDayConvention.Preceding);
		assertEquals("28/4/2006", d2.toString());
		d2 = Date.applyConvention(d3, BusinessDayConvention.ModifiedPreceding);
		assertEquals("2/10/2006", d2.toString());
	}
}
