import java.io.*;
import java.net.*;
import java.util.*;

public class URLGet {

	/**
		User agent string sent to the server.
	*/
	public String agent="Java-URLTils";
	
	/**
		Working socket is stored here
	*/
	public Socket s;
	
	/**
		Host string is stored here
	*/
	public String host="";
	
	/**
		Port is stored here, default 80.
	*/
	public int port=80;
	
	/**
		Requested path is stored here.
	*/
	public String path="";
	
	/**
		Any cookiedata added is stored here
	*/
	public String cookiedata="";
	
	/**
		Ouputstream is here.
	*/
	public BufferedWriter out;
	
	
	/**
		When using getText, inputstream hs iere.
	*/
	public BufferedReader in;
	
	/**
		Blank.. Don't use this
	*/
	public URLGet() {}
	
	/**
		Constructor for standard ports
		@param _host http host/ip to send request to
		@param _path path on remote server to fetch
	*/
	public URLGet(String _host, String _path) {
		host=_host;
		path=_path;
	}
	
	/**
		Constructor for non - standard ports
		@param _host http host/ip to send request to
		@param _path path on remote server to fetch
		@param _port port to send request on
	*/
	public URLGet(String _host, String _path, int _port) {
		host=_host;
		path=_path;
		port=_port;
	}
	
	/**
		Cookie formatted string: key=value; key2=value2;
		@param cd Cookie data string
	*/
	public void setCookieData(String cd) {
		cookiedata=cd;
	}
	
	/**
		Sends the http request to start request processing on the server
	*/
	public void sendRequest() throws IOException {
		s = new Socket(host, port);
		out = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
		String str="";
		str+="GET "+path+" HTTP/1.0\r\n";
		str+="Host: "+host+"\r\n";
		str+="User-Agent: "+agent+"\r\n";
		str+="Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\n";
		str+="Accept-Language: en-us,en;q=0.5\r\n";
		str+="Accept-Encoding: none\r\n"; //gzip,deflate
		str+="Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\n";
		str+="Keep-Alive: 300\r\n";
		str+="Connection: keep-alive\r\n";
		if(cookiedata.length()>0) { str+="Cookie: " + cookiedata + "\r\n"; }
		str+="\r\n";
		out.write(str);
		out.flush();
	}
	
	/**
		Closes the connection to the server.
	*/
	public void close() throws IOException {
		s.close();
	}
	
	/**
		Returns the text outputted by this request, including headers.
	*/
	public String getText() throws IOException {
		sendRequest();
		in = new BufferedReader(new InputStreamReader(s.getInputStream()));
		String content="";
		try {
			while(true) {
				String line = in.readLine();
				if(line==null) {
					break;
				}
				content+=line + "\n";
			}
		} catch (IOException ioe) {
		}
		return content;
	}
	
	/**
		Returns the inputstream associated with the request.
	*/
	public InputStream getStream() throws IOException {
		return s.getInputStream();
	}
	
	/**
		Returns a summary of this object
	*/
	public String toString() {
		return "URLGet request to "+host+" for "+path;
	}
}