/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package chat;



/**
 * A data structure for representing templates for a template driven language 
 * generator.
 * 
 * In short Class SentenceTemplate contains two fields:
 * sentenceType : Has the information whether the sentence is a Question or an Answer.
 * 
 * template : Has the canned text and the keywords %NOUN% and %ADJECTIVE% that are replaced with
 * an appropriate noun or adjective.
 * 
 *  @author Assignment by Priya Chandran
 */
public class SentenceTemplate {
    
    /**
     * The question sentence type
     */
    public static String QUESTION= "question";
    
    /**
     * The reply sentence type
     */
    public static String REPLY ="reply";
    
    /**
     * The type of sentence stored in this template
     * 
     * String sentenceType : Has the information whether the sentence is a Question or an Answer.
     * This can be implemented later on in the other classes in the heirarchy such that the conversation
     * always starts with a sentence of type Question.
     */
    
    private String sentenceType;
    
    /**
     * A string representing this template
     * 
     * String template : These are the templates with 'canned text' which is text already typed by the programmer
     * the regions in the canned text contain %NOUN% and %ADJECTIVE% that are to be filled in with the 
     * appropriate noun and adjective.
     */
    
    private String template;
    
    /** 
     * @param type The type of this template e.g. QUESTION
     * 
     * @param temp The string representation of this template
     */
    
    public SentenceTemplate(String type, String temp){
        sentenceType = type;
        template = temp;
    }

    /**
     * Gets the type of this sentence template
     * @return the type
     */
    public String getSentenceType() {
        return sentenceType;
    }

    /**
     * Get the string representation of the template
     * @return the template
     */
    public String getTemplate() {
        return template;
    }

    /**
     * Set the type of this sentence template
     * @param string the type
     */
    public void setSentenceType(String string) {
        sentenceType = string;
    }

    /**
     * Set the string representation of this template
     * @param string the template
     */
    public void setTemplate(String string) {
        template = string;
    }
    


}


