

package game;

/** 
 * This is the character class in the game "Escape from Alcatraz" .
 * The characters are represented by this class.. 
 * a character can pick up any number of items from the rooms. and they are added to an array list
 */


 import java.util.ArrayList;


public class Character {
    
    private String characterImage; //the character image file path
    private String characterDescription;    //description of the character 
    ArrayList<Item> itemList = null;

    private boolean badGuy;   //boolean 1 is badGuy person and boolean 2 is a bad person. you can not shoot badGuy people.
    
    /**
     *constructor for the Character class
    * @author priya
    */
    public Character(String characterName, String characterDescription, boolean bad ) {
        this.characterImage=characterName;
        this.characterDescription=characterDescription;
        this.badGuy=bad;
        itemList =  new ArrayList<Item>();
    }
    
    
    /**
     * sets an item for the character.
     * @param Item item
     */
    public void setitemforCharacter(Item item){
        itemList.add(item);
    }
    

    /**
     * checks if character has an item
     * @return boolean
     */
    public boolean hasItem(){
        return !(itemList==null);
    }

    /**
     * checks if the character is a bad guy or not
     * @return boolean
     */    
    public boolean isBadGuy(){
        return badGuy;
    }
    
    
    public String getCharacterImage(){
        return characterImage;
    }
    
    
    public String getDescription(){
        return characterDescription;
    }
    
    /**
     * returns the array list of items carried by the character.
     * @return ArrayList itemList
     */
    public ArrayList getItemList(){
     return itemList;
    }
}
