package game; 
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import java.io.*;



/**
 * This class is a part of the application "Escape from Alcatraz". It was created using a MAC OSX and the graphics display was optimised for
 * that. Although slight alterration might tend to occur in WINDOWS/ LINUX and other OS.
 * 
 * This class implements a simple graphical user interface with Buttons and a text output area and an optional images.
 * 
 * It has an instance of GameEngine in it called as engine. A lot of data for this class comes from the GameEngine. The
 * 
 * The private static variables are used by more than one method in this Class. There is only one instance of these created. 
 * They form the large number of variables that are used to integrate the GUI here.
 * 
 * 
 * All file names are referred here without their extension. They are .jpg images which are located in root folder of this project.
 * 
 * @author Priya Chandran
 * @version 1.0 (Jan 2003)
 * 
 */
public class UserInterface
{   private static final String VERSION = "Version 1.0";
    
              
    private static GameEngine engine;               //This is the single instance of the GameEngine for the Class
    
    private static JFrame frame;                    //This is the main frame where the Game commands are displayed
    private static String globalInfor;              //globalInformation string is used to display information on the frame.
                                                    //like currentRoom details.
    private static String currentRoomPath;    //this is the link to the room image path
                                                       
    private static JPanel roomPanel = new JPanel(); //This is the panel displaying the roomDetails. It is the south border element of frame
    private static JPanel informationPanel = new JPanel();  //used to display information on the room status
    private static JPanel characterPanel = new JPanel();    //this is used to display the character image
    private static JPanel itemPanel= new JPanel();          //this is used to display item image
    private static JPanel itemInformationPanel= new JPanel();   //this is used to display item image
    private static Container containerPane = new Container();   //this is the main container Panel
    private JPanel commandPanel = new JPanel();          //the main command Panel on the right
    private static JLabel roomLabel= new JLabel();              //this holds the room Image icon
    private static JLabel characterLabel=new JLabel();          //this holds the character image icon
    private static ImageIcon characterIcon = new ImageIcon();   //the image of the character
    private static JLabel itemLabel=new JLabel();               //this holds the ImageIcon of the item
    private static JLabel itemInformation=new JLabel();         //shows the item details..whether it can be picked up or not
    private static JLabel informationLabel= new JLabel();       
    private static Button shootButton = new Button("Shoot");    //shoot button is active only after picking up a gun
    private static ImageIcon itemIcon = new ImageIcon();        
    private static JFrame quitFrame=new JFrame("Quit?");        //this frame is visible once the user presses newGame
    private static JFrame introFrame=new JFrame("Welcome to the game"); //introduction frame with story line
    private static JLabel conversationLabel= new JLabel("Conversation appears here"); //the conversation appears in this label   
    private static JPanel mainLeftPanel = new JPanel();         //main left panel containing command buttons
    private static JButton talkButton=new JButton("TALK");      //the talk button appears only when 'good' characters are there in a room
    private static SoundEngine sound=new SoundEngine();         //this instance is used to play the sound clips
    private static JFrame exitFrame=new JFrame();               //this is the GameOver frame
    private static  File door=new File("door.wav");             // The following are the sound files.
    private static  File gameOver=new File("gameOver.wav");
    private static File gameStart=new File("intro.wav");
    private static  File gunshot=new File("gunshot.wav");
    private static  File itemTake=new File("itemTake.wav");
    private static  JPanel introPanel=new JPanel();             //introduction panel
    private static  JLabel introLabelImage=new JLabel();
    private static ImageIcon introImage=new ImageIcon();
    private static JLabel introText=new JLabel();
    private static  Button goButton=new Button("GO");
    private static Boolean firstRun=true;                       //this is to make sure that the story line is displayed only during the first run.
    
    
    
    /**
     * Construct a UserInterface. As a parameter, a Game Engine
     * (an object processing and executing the game commands) is
     * needed.
     * if this is the first time that the game is running then the introduction story line is displayed. Otherwise the game is just loaded. 
     * The boolean firstRun is used for this purpose.
     * 
     * @param gameEngine  The GameEngine object implementing the game logic.
     */
    public UserInterface(GameEngine gameEngine)
    {   
        
        engine = gameEngine;        //creates an instance of gameEngine
        if(firstRun){
        introduction();
        }
        else{
            makeFrame();
        }
        
    }
    
    
    
    /**
     * This creates the frame that is used to display the storyline and the introduction to the user.
     * The user starts the game by pressing the Go button. This frame is displayed only at the start of the Game.
     * 
     */
    private void introduction(){
        introFrame.setSize(900,700);
        Container introContainer=introFrame.getContentPane();
        sound.play(gameStart);
    //    introPanel.setLayout(new BoxLayout(introPanel, BoxLayout.Y_AXIS));  
        introPanel.setBackground(Color.WHITE);
        
        introImage=new ImageIcon("intropic.jpg");
        introText=new JLabel("<HTML> You are a time traveller named Niro who traverses space and time."+"<BR> The year AD2067 is full of crime." +
                "You are taken <BR> to be a law-breaker and you are put in a ruthless prison.<BR> <BR> Plan your escape from Prison..<BR><BR>" +
                "You must find the time machine<BR> and escape soon. " +
                "Click on the GO Button to start your<BR> adventure</HTML>"); 
        introText.setFont(new Font("Serif", Font.BOLD, 18));
        
          goButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
                          goButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent e) { playGame(); }
                           });

        introLabelImage.setIcon(introImage);
        introPanel.add(introText);
        introPanel.add(introLabelImage);
        introPanel.add(introText);
        introPanel.add(goButton);

        introContainer.add(introPanel);
        
        //the following code is used to set the frame at the center of the frame. It is repeated a for all new frames in this 
        //assignment. A separate method can be built to reduce duplication here.
        
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = introFrame.getSize();
        introFrame.setDefaultCloseOperation(1);
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        introFrame.setLocation(x, y);
        introFrame.setVisible(true);
    }
    
    /**
     * This makes the introduction not visible and creates the Game frame. 
     */
    
    public void playGame(){
        introFrame.setVisible(false);
        makeFrame();
    }
    
    
    
    /**
     * The method is used to emulate the word command "go north". enums need not be used here at the gameEngine since
     * its a command Button.
     */
    private void goNorth(){
               
        engine.interpretCommand("go north");
      // new File(AUDIO_DIR, filename)

    }
    
    /**
     * this method is called when south button is pressed
     */
    private void goSouth(){
        engine.interpretCommand("go south");
    }
    
    /**
     * this method is called when west button is pressed
     */
    private void goWest(){
        engine.interpretCommand("go west");
    }
    
    /**
     * this method is called when east button is pressed
     */
    private void goEast(){
        engine.interpretCommand("go east");
    }
    
    /**
     * this method is called when "where am I?" button is pressed
     */
    private void help(){
        engine.interpretCommand("help");
    }
    
    
    /**
     * this method is called when shoot button is pressed. A user will be able to shoot only after 
     * a gun is picked up
     */
    private void shoot(){
        engine.interpretCommand("shoot");
        
    }
    
    
    /**
     * this method is called when pick up button is pressed. This causes an item to be added to 
     * the users Item List
     */
    private void pickUp(){
        engine.interpretCommand("pick");
        sound.play(itemTake);
    }
    
    
    /**
     * this method is called when talk button is pressed. It displays some text from the character randomly
     */
    private void talk(){
        engine.interpretCommand("talk");
    }
    
    
    /**
     * this method is called "new Game". It asks the user confirmation whether the game should restart.
     * restarting the game would lose all the information in the Game
     */
    
    public void newGame(){
                
                quitFrame.setSize(400,100);
                Container quitContainer=quitFrame.getContentPane();
                JPanel quitPanel=new JPanel();
                JLabel quitLabel1=new JLabel("New game willl quit the current Game");
                JLabel quitLabel2=new JLabel("Are you sure you want to start New Game?");
                Button yesButton=new Button("Yes");
                yesButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
                          yesButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent e) { yesRestart(); }
                           });
                
                Button noButton=new Button("No");
                noButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
                          noButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent e) { noRestart(); }
                           });
                quitPanel.add(quitLabel1);
                quitPanel.add(quitLabel2);
                quitPanel.add(yesButton);
                quitPanel.add(noButton);
                quitContainer.add(quitPanel);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension frameSize = quitFrame.getSize();
                int x = (screenSize.width - frameSize.width) / 2;
                int y = (screenSize.height - frameSize.height) / 2;
                quitFrame.setLocation(x, y);
                frame.setVisible(false);
                quitFrame.setVisible(true);
                
                
       //         System.out.println(engine.getCurrentRoom());
       //         setCurrentRoomPath(engine.getCurrentRoom());
    }
    
    
    /**
     * this method is used to restart the game
     */
    private void yesRestart(){
                engine = new GameEngine();
                firstRun=false;
		UserInterface gui = new UserInterface(engine);
		engine.setGUI(gui);
    }
    
    
    /**
     * this method is used to resume the game
     */
    private void noRestart(){
        frame.setVisible(true);
        quitFrame.setVisible(false);
    }
    
    //quits the game
    private void quit(){
         System.exit(0);    
    }
    
    
    //play sound when the door can be opened
    public void doorSuccess(){
                sound.play(door);

    }
    
    //plays sound when a guard is shot.
    public void shootSuccess(){
        sound.play(gunshot);
    }
    
    
    
    /**
     * this method is creates the main GUI for playing the game. The GUI is sarranged in this way
     * There is a manframe with a containerPane that is in a box layout. with no north component. inside each there is either
     * a flow layout or a box layout that is represented by JPanels. Within the JPanels there is a box layout or a flow layout again.
     * 
     * The images are embedded into image icons, which in turn are put into their labels, then they are added to their respective JPanels
     */
    private void makeFrame()
    {   
        currentRoomPath=engine.getCurrentRoom();        //gets the path to the current room
        frame = new JFrame("Escape from Alcatraz");
        frame.setSize(200, 200);
        Image img = Toolkit.getDefaultToolkit().getImage("prison_icon.gif");
        frame.setIconImage(img);
        frame.setDefaultCloseOperation(1);
        
        containerPane = frame.getContentPane();                
        
        
        
        JPanel conversationPanel = new JPanel();
        conversationLabel.setFont(new Font("Serif", Font.BOLD, 22));
        conversationLabel.setForeground(Color.DARK_GRAY);
        JPanel speechPanel=new JPanel();
        speechPanel.add(conversationLabel);
        conversationPanel.setBackground(Color.BLACK);
        conversationPanel.setLayout(new BoxLayout(conversationPanel, BoxLayout.Y_AXIS));
        globalInfor=engine.getCurrentRoomDetails();
        conversationPanel.add(speechPanel);
        conversationPanel.add(createInformationPanel());
        conversationPanel.add(createItemInformationPanel("INFORMATION ON ITEMS IN THIS ROOM ARE DISPLAYED HERE"));
        
        mainLeftPanel.setBackground(Color.BLACK);
        mainLeftPanel.setLayout(new BoxLayout(mainLeftPanel, BoxLayout.Y_AXIS));        
        mainLeftPanel.add(createCharacterPanel()); 
        mainLeftPanel.add(createItemPanel());
        mainLeftPanel.add(createTalkButton());
        

        
        JPanel mainCommandPanel= new JPanel();
        mainCommandPanel.setLayout(new BoxLayout(mainCommandPanel, BoxLayout.Y_AXIS));
        mainCommandPanel.setBackground(Color.BLACK);
        mainCommandPanel.add(createCommandPanel());
        mainCommandPanel.add(createDirectionPanel());
        mainCommandPanel.add(createCommentPanel());
        mainCommandPanel.add(createHelpButton());
        
     
        
        roomPanel.setPreferredSize(new Dimension(500, 500));
        roomPanel.add(createRoomImage());
        roomPanel.setBackground(Color.BLACK);
        
        containerPane.add(conversationPanel, BorderLayout.SOUTH);
        containerPane.add(mainLeftPanel, BorderLayout.WEST);
        containerPane.add(mainCommandPanel, BorderLayout.EAST);
        containerPane.add(roomPanel, BorderLayout.CENTER);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        makeMenuBar(frame);
        
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        frame.setLocation(x, y);
        frame.setVisible(true);
        
    }
    
    /**
     * creates the commandPanel on the right of the GUI. The command Panel has both create and update methods for all the components that
     * are used to display updated information inside each room.
     * @return JPanel that has a part of the left side part of the screen
     */
    
    
     private JPanel createCommandPanel(){
        commandPanel.setBackground(Color.BLACK);

        shootButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent e) { shoot(); }});
        shootButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
        shootButton.setForeground(Color.WHITE);
        shootButton.setVisible(false);
        commandPanel.add(shootButton);
        Button pickButton= new Button("Pick up Item");
        pickButton.setBackground(Color.WHITE);
        pickButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
                pickButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent e) { pickUp(); }});
        commandPanel.add(pickButton);
        return commandPanel;
        }
     
     
     /**
      * this creates the talk button. This button is used to start a conversation with a character. 
      * initially its display is set to false
      * The talk button appears only when a 'good' character is present in the room
      * @return JButton the talk button
      */
     
     public JButton createTalkButton(){
        talkButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
        talkButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent w) { talk(); }
                           });
                           
        talkButton.setVisible(false);           
        return talkButton;
    }
    
     
     /**
      * depending on whether a character is there in a room or not the talk button is displayed. This is 
      * called from the gameEngine
      * @param canTalk - a boolean representing if a character in the room can talk. 
      */
     
     public void updateTalkButton( Boolean canTalk){
         if(canTalk) {
             talkButton.setVisible(true);
         }
         else{
             
         
         talkButton.setVisible(false);
         }
         mainLeftPanel.updateUI();
        
     }
     
     
     /**
      * This is used to update the command Panel. If the user has picked up a gun then the shoot button is set to visible.
      * 
      */
     public void updateCommandPanel(){
          if(engine.doesHeroHaveGun()){
            shootButton.setVisible(true);
            commandPanel.updateUI();
        }
     } 
      
     /**
      * the direction panel has a border layout, with the north, south, east,west positions occupied by the respective "go" buttons
      * @return a JPanel containing the direction buttons
      */
     private JPanel createDirectionPanel(){
        JPanel directionPanel = new JPanel(new BorderLayout());
        
        directionPanel.setBackground(Color.BLACK);
        directionPanel.add(new JLabel("COMMANDS"));        
        JButton northButton=new JButton("GO NORTH");
        northButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
        
        northButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent n) { goNorth(); }
                           });
        JButton southButton=new JButton("GO SOUTH");
        southButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
        southButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent s) { goSouth(); }
                           });
                           
        JButton eastButton=new JButton("GO EAST");
        eastButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
        eastButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent e) { goEast(); }
                           });
                           
        JButton westButton=new JButton("GO WEST");
        westButton.setCursor (new Cursor (Cursor.HAND_CURSOR));
        westButton.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent w) { goWest(); }
                           });
        
        directionPanel.add(northButton,BorderLayout.NORTH);
        directionPanel.add(southButton,BorderLayout.SOUTH);
        directionPanel.add(eastButton,BorderLayout.EAST);
        directionPanel.add(westButton,BorderLayout.WEST); 
        
        return directionPanel;        
        }
        
    /**
     * this is a comment comprising some important information given to the user. Here HTML is embedded into the string since JLAbels
     * can reconize that for BREAKS in the links. This makes a single line statement into a multiline comment.
     * @return panel with the comment to be inserted in to the left bottom of the screen.
     */ 
    private JPanel createCommentPanel(){
        JPanel commentPanel = new JPanel();
   //     commentPanel.setSize(80,200);
        commentPanel.setBackground(Color.BLACK);
        JLabel commentLabel = new JLabel("<HTML> <BR> <BR> <BR> PLAN OUT YOUR ESCAPE FROM PRISON..<BR><BR>" +
                "YOUR GOALS:<BR> YOU MUST FIND THE TIME MACHINE<BR><BR> ON YOUR WAY YOU WILL MEET AGENTS<BR> WHO WILL HELP YOU " +
                "<BR>BEWARE OF PRISON GUARDS" +
                "<BR>THEY WILL SHOOT YOU IF THEY SEE YOU <BR>" +
                "<BR>PICK UP ANY ITEMS IN A ROOM USING<BR> THE 'TAKE' BUTTON<BR><BR>" +
                "CLICKING ON 'WHERE AM I?'<BR>" +
                "SHOWS YOUR PRESENT LOCATION<BR><BR> </HTML>");
        commentLabel.setForeground(Color.WHITE);
        commentPanel.add(commentLabel);
        return commentPanel;
    }
   
    
    /**
     * creates the character Panel. displays the characters image. The default image is tht of the alcatraz prison. which is displayed 
     * if there is no character in the room. initially it is assumed that there are no characters in the room
     * @return panel with the characters image or default image
     */
    private JPanel createCharacterPanel(){
        
        
        characterPanel.setBackground(Color.BLACK);
        characterLabel.setBounds(300, 300, 200, 200);
        
        characterIcon = new ImageIcon(resizeImages("default.jpg",characterLabel)); 
        
        characterLabel.setIcon(characterIcon);
        characterPanel.add(characterLabel);
        return characterPanel;
    }
    
    
    /**
     * this is used to update the image of the character which appears in every room
     * @param newpath is the path to the new image file at every room
     */
    public void updateCharacterPanel(String newpath){
        characterIcon = new ImageIcon(resizeImages(newpath+".jpg",characterLabel)); 
        characterLabel.setIcon(characterIcon);
        characterPanel.updateUI();
    }
 
    /**
     * this is used to display the items that are contained in every room. Again it is assumed that there are no items in the starting room
     * This could be further improved by implementing a method to check if there are an items in the room.
     * @return panel containing a label with image of the item
     */
    private JPanel createItemPanel(){
        
        itemPanel.setBackground(Color.BLACK);
        itemLabel.setBackground(Color.BLACK);
        itemLabel.setBounds(300, 100, 150, 150);
        itemIcon = new ImageIcon(resizeImages("noitem.jpg",itemLabel));        
        itemLabel.setIcon(itemIcon);
        itemPanel.add(itemLabel);
        return itemPanel;
    }
    
    
    /**
     * this is updated each time a user enters a room. Every item is associated with an itemImage with is the path to the
     * image file.
     * @param itemImage- the path of the new item image
     */
    public void updateItemPanel(String itemImage){
        
        itemLabel.setBounds(300,100,150,150);
        itemIcon = new ImageIcon(resizeImages(itemImage+".jpg",itemLabel));        
    //    itemIcon.setDescription(itemDetails);
       itemLabel.setIcon(itemIcon);
    //    JLabel itemDesc=new JLabel(itemDetails);
    //    itemDesc.setForeground(Color.WHITE);
    //    itemPanel.setIcon(itemLabel);
    //    itemPanel.add(itemDesc);
        itemPanel.updateUI();
    }
    
    
    /**
     * the item informtion panel shows the details of the items in the room
     * @param itemDetails. A string containing a small detail about the item
     * @return Panel containing the items information
     */
    private JPanel createItemInformationPanel( String itemDetails)
    {   
        itemInformation.setForeground(Color.black);
        itemInformation.setFont(new Font("Serif", Font.BOLD, 22));

        itemInformation.setText(itemDetails);
        
        itemInformationPanel.add(itemInformation);
        return itemInformationPanel;
    }
    
    
    /**
     * this updates the item information at every room If there is no item it shows that there is no item in the room.
     * @param itemDetails - String containing the details on the item
     */
    public void updateItemInfo(String itemDetails)
    {
        itemInformation.setText("ITEM INFORMATION: "+itemDetails);
        itemInformationPanel.add(itemInformation);
        itemInformationPanel.updateUI();
    }
    
    
    /**
     * this is the global information that would be useful to the player. It displays information on the location and exits.
     * @return panel with the initial global information string.
     */
    private JPanel createInformationPanel(){
        
        informationLabel.setText(globalInfor);
        informationLabel.setFont(new Font("Serif", Font.BOLD, 22));

        informationPanel.setBackground(Color.BLACK);
        informationLabel.setForeground(Color.WHITE);
        informationPanel.add(informationLabel);
        return informationPanel;
    }
    
    
    /**
     * creates a room image from the currentRoomPath. 
     * This method uses a reaizeImages() to resize image to the size of the label. This allows flexibility to use any image for a room
     * 
     * @return a roomlabel with the room image set on it. 
     */
    private JLabel createRoomImage(){
        currentRoomPath="r01";
        roomLabel.setBounds(500, 100, 500, 500);
        ImageIcon roomIcon = new ImageIcon(resizeImages(currentRoomPath+".jpg",roomLabel));
  //      ImageIcon roomIcon = new ImageIcon(resizeImages(path+"room_images/"+currentRoomPath+".jpg",roomLabel));
        roomLabel.setIcon(roomIcon);
     //   roomLabel.updateUI();
    //    roomPanel.updateUI();
        return roomLabel;
    }
       
    /**
     * this method updates the current room image path so that the room image get updated inthe GUI
     * @param roomPath- a String to the room image file name with out the extension.
     */
    public void setCurrentRoomPath(String roomPath)
        {System.out.println("came to roompath");
        currentRoomPath=roomPath;
        System.out.println(roomPath);
        roomPanel.setPreferredSize(new Dimension(500, 500));
        ImageIcon newIcon = new ImageIcon(resizeImages(currentRoomPath+".jpg",roomLabel));
        roomLabel.setIcon(newIcon);
        roomLabel.updateUI();
        roomPanel.updateUI();

        
    }
    
    
    /**
     * this shows an updated status of the users location. Since the same space in the GUI is used to display other information
     * the user can click this button and get an update on this locations.
     * @return helpButton
     */
    private JButton createHelpButton(){
                JButton help=new JButton("Where am I?");
        help.setCursor (new Cursor (Cursor.HAND_CURSOR));
        help.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent w) { help(); }
                           });
        return help;
    }

    

    /**
     * this method is used to resize the image files to the imageLabel size to allow flexibility in images.
     * @param path : path of the image file
     * @param imageLabel : the label into which the image needs to be fit.
     * @return Image: the resized image
     */
    private Image resizeImages(String path, JLabel imageLabel)
    {
        Image originalImage = Toolkit.getDefaultToolkit().getImage(path);

        Image resizedImage = originalImage.getScaledInstance(imageLabel.getWidth(),imageLabel.getHeight(),Image.SCALE_DEFAULT);
        return resizedImage;
    }

    
    /**
     * this is used to update the conversation Label whenever the 'talk' button is pressed.
     * @param Speech
     */
    public void updateConvesation(String Speech){
        
        conversationLabel.setText(Speech);
        conversationLabel.updateUI();
    }
    
    
    
    /**
     * this creates teh menuBar which has the buttons 'new game' and 'quit'.
     * @param frame : the frame into which the menubar needs to be set.
     */
        private void makeMenuBar(JFrame frame)
    {
        final int SHORTCUT_MASK =
            Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();


        JMenuBar menubar = new JMenuBar();
        menubar.setBackground(Color.BLACK);
        frame.setJMenuBar(menubar);
        
        JMenu menu;
        JMenuItem item;
        
        // create the File menu
        menu = new JMenu("Game Options");
        menubar.add(menu);
        
        item = new JMenuItem("New Game :");
            item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, SHORTCUT_MASK));
            item.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent e) { newGame(); }
                           });
        menu.add(item);

        
        item = new JMenuItem("Quit");
            item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, SHORTCUT_MASK));
            item.addActionListener(new ActionListener() {
                               public void actionPerformed(ActionEvent e) { quit(); }
                           });
        menu.add(item);

        // create the Help menu

    }
        
        
    /**
     * This updates the information label each time a player enters a room. The input for this is from the gameEngine.
     * @param commandLine
     */
    public void println(String commandLine) {
        informationLabel.setText(commandLine);
        informationPanel.updateUI();
    }
    
    /**
     * this frame is used to display the game over grame. it makes the main frame invisible and shows the user if they have won/lost the game
     * @param text - success or failure of the game. This is called from the GameEngine.
     * @param image - the path to images if the game is successful or unsuccessful
     */
    public void gameOver(String text, String image){
        frame.setVisible(false);
        sound.play(gameOver);
                introImage=new ImageIcon(image);
        introText.setText(text);
        introText.setFont(new Font("Serif", Font.BOLD, 22));
        goButton.setVisible(false);
        introLabelImage.setIcon(introImage);
        introPanel.updateUI();
        introFrame.setVisible(true);
    }
    
    
}
