package net.bytebuffer.commons;
import java.util.List;

import net.bytebuffer.music.data.*;

/**
 * 
 * @author ferdinand
 *
 * @param <T>
 */

public interface DAO<T> {
	
	// Exportieren des VO in DB
	public T create(T vo) throws DataAccessException;
	
	// Updaten des VO in DB
	public void update(T vo) throws DataAccessException;

	// Finden eines VO mit spezieller id in DB
	public T findById(int id) throws DataAccessException;
	
	// Finden aller VO in DB
	public List<T> findAll() throws DataAccessException;
	
	// Löschen des VO aus DB
	//public void removeByID(int id) throws DataAccessException;
	
	// Löschen des VO aus DB
	//public void remove(T vo) throws DataAccessException;
	
	
}
