package net.bytebuffer.commons;

import java.io.IOException;
import java.lang.ClassNotFoundException;
import java.lang.InstantiationException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.ServletConfig;
import java.util.HashMap;
import net.bytebuffer.*;


public abstract class HttpServletControllerBase extends HttpServlet {
	
	protected HashMap<String,HttpRequestActionBase> actions;

	public void init() throws ServletException{

	}
	
	/**
	 * Operation zum Parsen der Url
	 * @param req HttpRequest
	 * @return Name der Aktion die ausgefhrt wird
	 */
	protected abstract String getOperation(HttpServletRequest req);
	
	/**
	 * Reagiert auf einen GET-Request und fhrt entsprechende Aktion aus
	 * @param req
	 * @param resp
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
		throws ActionAccessException,ServletException,IOException{
		String op=getOperation(req);
		HttpRequestActionBase action=null;
		if (actions.containsKey(op)) action=actions.get(op);	
		else 
			if(actions.containsKey("Default")) action=actions.get("Default");	
			else throw new ActionAccessException("Action "+op+" unbekannt");

		try{
			action.perform(req, resp);	
		}
		catch(IOException ex){
			throw new ActionAccessException("Action nicht ausfhrbar.",ex);
		}
	}
	
	/**
	 * Reagiert auf einen GET-Request und fhrt entsprechende Aktion aus
	 * @param req
	 * @param resp
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse resp)
		throws ActionAccessException,ServletException{
		String op=getOperation(req);
		HttpRequestActionBase action=actions.get(op);
		if (action==null) throw new ActionAccessException("Action "+op+" unbekannt");
		try{
			action.perform(req, resp);	
		}
		catch(IOException ex){
			throw new ActionAccessException("Action nicht ausfhrbar.",ex);
		}

	}
	
	
	
}