package test;

import repository.HibernateUtil;
import org.hibernate.*;
import data.*;
import java.util.Date;
import manager.EntityManager;

/**
 *  Collection Mapping  - ok
 *  Inheritance Mapping - ?
 *  Association Mapping - ???
 * 
 * 
 * @author Ferdinand Kaiser, 06.04.08
 *
 */
public class MappingTest2 {
	
	
	private static void showArticle(Article article){
		System.out.println();
		System.out.println("----"+article.getTitle()+"----");
		System.out.println("Created "+article.getCreationDate()+" Last Edit "+article.getLastEdit());
		System.out.println("Deleted "+article.isDeleted());
		System.out.println(article.getText());
		System.out.println("----Comments----");
		try{
			for(Comment comment:article.getComments()){
				System.out.println(comment.getText());
			}
		}
		catch(NullPointerException ex){
			System.out.println("No Comments.");
		}
		System.out.println();
	}
	

	public static void main(String[] args)
	{
		Session session=HibernateUtil.getSessionFactory().getCurrentSession();
		session.beginTransaction();

		EntityManager em=new EntityManager(session);
		
		//Adding Article
		Article article=em.createAndStoreArticle("All I Need","Radiohead");
		showArticle(article);

		// Add comment
		em.createAndStoreComment(article.getId(),"^^");
		em.createAndStoreComment(article.getId(),":-)");
		
		showArticle(article);

		// Updating article
		em.updateArticle(article.getId(), article.getTitle(),"Radiohead 2007", false);
		showArticle(article);
		
		session.getTransaction().commit();
}
	
	
	
}
