package action.article;

import manager.DAOManager;
import helpers.*;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.User;

import exception.MissingValueException;
import exception.NoSuchArticleException;

/**
 * Adds a comment to given article
 * 
 * @author Roland Krner
 *
 */
@Results( {
		@Result(name = "success", value = "/articleDetail.action?id=${id}", type = ServletRedirectResult.class),
		@Result(name = "error", value = "/error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
@Validation
public class AddArticleCommentAction {

	private int id;
	private String comment;
	private User user;

	/**
	 * Adds a comment to a given article.
	 * 
	 * @return success, if comment was added
	 * 			error, if user has no permission or article doesn't exist
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");

		if (user == null)
			return "error";
		
		comment = StringHelper.stripHtml(comment);
		comment = StringHelper.nl2br(comment);
		
		try {
			if (DAOManager.getCommentDAO().createArticleComment(user, "",
					comment, id) != null)
				return "success";
			else
				return "error";
		} catch (NoSuchArticleException e) {
			return "error";
		} catch (MissingValueException e) {
			return "error";
		}
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	@RequiredStringValidator(message = "Text bentigt!")
	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}
}
