package action.article;

import helpers.PagerHelper;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import manager.DAOManager;
import data.*;
import exception.NoSuchArticleException;

import com.opensymphony.xwork2.ActionContext;

/**
 * Retrieves data for a given article
 * 
 * @author Roland Krner
 *
 */

@Results( {
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class),
		@Result(name = "success", value = "/article/articleDetail.jsp", type = ServletDispatcherResult.class) })
@Namespace(value = "/")
public class ArticleDetailAction {

	private int id;
	private Article article;
	private List<Comment> comments;
	private List<Tag> tags;
	private ArrayList<Integer> commentPages;
	private int commentPage;

	private User user;

	/**
	 * Retrieves data for a given article
	 * 
	 * @return success, data was retrieved
	 * 			error, if article doesn't exist
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");

		try {
			setArticle(DAOManager.getArticleDAO().getById(id));
		} catch (NoSuchArticleException e) {
			return "error";
		}

		comments = article.getComments();

		commentPages = new ArrayList<Integer>();

		PagerHelper.fillArray(comments, commentPages, 3);

		return "success";
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public List<Comment> getComments() {
		return comments;
	}

	public void setComments(List<Comment> comments) {
		this.comments = comments;
	}

	public List<Tag> getTags() {
		return tags;
	}

	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}

	public Article getArticle() {
		return article;
	}

	public void setArticle(Article article) {
		this.article = article;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public ArrayList<Integer> getCommentPages() {
		return commentPages;
	}

	public void setCommentPages(ArrayList<Integer> commentPages) {
		this.commentPages = commentPages;
	}

	public int getCommentPage() {
		return commentPage;
	}

	public void setCommentPage(int commentPage) {
		this.commentPage = commentPage;
	}
}
