package action.article;

import helpers.StringHelper;

import java.io.File;
import java.util.List;
import java.util.UUID;

import manager.DAOManager;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletRedirectResult;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.*;
import exception.MissingValueException;

/**
 * Takes formdata and creates a new article.
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "articleDetail.action?id=${id}", type = ServletRedirectResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
@Validation
public class CreateArticleAction {

	private User owner, user;
	private String title, text;
	private File image;
	private String imageFileName, imageContentType;
	private List<Tag> availableTags;
	private List<Tag> tags;
	private int tagID, id;

	/**
	 * Takes formdata and creates a new article.
	 * 
	 * @return success, if comment was added error, if user has no permission or
	 *         article wasn't created
	 */
	public String execute() {

		user = (User) ActionContext.getContext().getSession().get("user");
		if (user == null)
			return "error";

		Image tempImage = null;
		if (image != null) {

			String dataDir = ServletActionContext.getServletContext()
					.getRealPath("/WEB-INF/upload/");
			String fileName = UUID.randomUUID().toString();
			File saveFile = new File(dataDir, fileName);
			image.renameTo(saveFile);

			try {
				tempImage = DAOManager.getImageDAO().createAndStore(
						image.getName(), fileName, dataDir, imageContentType);
			} catch (MissingValueException e) {
				// ignore
			}

		}

		text = StringHelper.stripHtml(text);
		text = StringHelper.nl2br(text);

		
		Article article;
		try {
			article = DAOManager.getArticleDAO().createAndStore(user, title,
					text, tempImage);
		} catch (MissingValueException e) {
			return "error";
		}
		id = article.getId();

		if (id == 0)
			return "error";
		else
			return "success";
	}

	public User getOwner() {
		return owner;
	}

	public void setOwner(User owner) {
		this.owner = owner;
	}

	@RequiredStringValidator(message = "Kein Titel vorhanden!")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@RequiredStringValidator(message = "Kein Text vorhanden!")
	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public File getImage() {
		return image;
	}

	public void setImage(File image) {
		this.image = image;
	}

	public List<Tag> getAvailableTags() {
		return availableTags;
	}

	public void setAvailableTags(List<Tag> availableTags) {
		this.availableTags = availableTags;
	}

	public List<Tag> getTags() {
		return tags;
	}

	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}

	public int getTagID() {
		return tagID;
	}

	public void setTagID(int tagID) {
		this.tagID = tagID;
	}

	public String getImageFileName() {
		return imageFileName;
	}

	public void setImageFileName(String imageFileName) {
		this.imageFileName = imageFileName;
	}

	public String getImageContentType() {
		return imageContentType;
	}

	public void setImageContentType(String imageContentType) {
		this.imageContentType = imageContentType;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}
}
