package action.article;

import helpers.StringHelper;

import java.util.Calendar;
import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;

import manager.DAOManager;

import data.Article;
import data.User;
import exception.NoSuchArticleException;

/**
 * Takes formdata and edits Article
 * 
 * @author Roland Krner
 *
 */
@Results( {
		@Result(name = "success", value = "articleDetail.action?id=${id}", type = ServletRedirectResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
public class DoEditArticleAction {

	private Article article;
	private int id;
	private User user;

	/**
	 * Takes formdata and edits Article
	 * 
	 * @return success, if article was edited
	 * 			error, if user has no permission or article doesn't exist
	 */
	public String execute() {
		Article article;
		user = (User) ActionContext.getContext().getSession().get("user");
		if (user == null)
			return "error";

		this.article.setText(StringHelper.stripHtml(this.article.getText()));
		this.article.setText(StringHelper.nl2br(this.article.getText()));

		
		try {
			article = DAOManager.getArticleDAO().getById(id);
			article.setTitle(this.article.getTitle());
			article.setText(this.article.getText());
			article.setLastEdit(Calendar.getInstance().getTime());

		} catch (NoSuchArticleException e) {

			return "error";
		}

		return "success";
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public Article getArticle() {
		return article;
	}

	public void setArticle(Article article) {
		this.article = article;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

}
