
package action.article;

import helpers.StringHelper;
import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.Article;
import data.User;
import exception.NoSuchArticleException;

/**
 * Retrieves Article data for given id and fills form
 * 
 * @author Roland Krner
 *
 */
@Results( {
		@Result(name = "success", value = "/article/editArticle.jsp", type = ServletDispatcherResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
@Validation
public class EditArticleAction {

	private Article article;
	private int id;
	private User user;

	/**
	 * Retrieves Article data for given id and fills form.
	 * 
	 * @return success, article was retrieved
	 * 			error, if user has no permission or article doesn't exist
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");

		if (user == null)
			return "error";

		try {
			setArticle(DAOManager.getArticleDAO().getById(id));
		} catch (NoSuchArticleException e) {
			return "error";
		}
		
		this.article.setText(StringHelper.stripHtml(this.article.getText()));

		return "success";
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public Article getArticle() {
		return article;
	}

	public void setArticle(Article article) {
		this.article = article;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}
}
