package action.article;

import helpers.PagerHelper;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.dispatcher.ServletDispatcherResult;

import manager.DAOManager;

import data.Article;
import data.User;
import exception.NoSuchArticleException;
import com.opensymphony.xwork2.ActionContext;

/**
 * Lists all articles
 * 
 * @author Roland Krner
 *
 */
@Result(name = "success", value = "/article/listArticles.jsp", type = ServletDispatcherResult.class)
@Namespace(value = "/")
public class ListArticlesAction {

	private List<Article> articles;
	private ArrayList<Integer> articlePages;
	private int articlePage;
	private User user;

	/**
	 * Lists all articles
	 * 
	 * @return success
	 * 			
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");

		try {
			setArticles(DAOManager.getArticleDAO().getList());
		} catch (NoSuchArticleException e) {
			//ignore
		}
		articlePages = new ArrayList<Integer>();
		PagerHelper.fillArray(articles, articlePages, 20);

		return "success";

	}

	public List<Article> getArticles() {
		return articles;
	}

	public void setArticles(List<Article> articles) {
		this.articles = articles;
	}

	public ArrayList<Integer> getArticlePages() {
		return articlePages;
	}

	public void setArticlePages(ArrayList<Integer> articlePages) {
		this.articlePages = articlePages;
	}

	public int getArticlePage() {
		return articlePage;
	}

	public void setArticlePage(int articlePage) {
		this.articlePage = articlePage;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}
}
