package action.event;

import java.util.Date;
import java.util.List;

import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.Event;
import data.Location;
import data.User;
import exception.NoSuchEventException;
import exception.NoSuchLocationException;

/**
 * Retrieves data for given event id to fill form
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "/event/editEvent.jsp", type = ServletDispatcherResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
@Validation
public class EditEventAction {

	private Event event;
	private int id;
	private Date startDate, endDate;
	private String startTime, endTime;
	private List<Location> locationList;

	/**
	 * Retrieves data for given event id to fill form.
	 * 
	 * @return success<br>
	 *         error, if user has no permission or event doesn't exist
	 */
	public String execute() {

		User user = (User) ActionContext.getContext().getSession().get("user");

		if (user == null)
			return "error";

		try {
			setLocationList(DAOManager.getLocationDAO().getList());
		} catch (NoSuchLocationException e) {
			// ignore
		}
		try {
			setEvent(DAOManager.getEventDAO().getById(id));
		} catch (NoSuchEventException e) {
			return "error";
		}

		startDate = event.getStartDate();
		startTime = helpers.DateHelper.getTime(event.getStartDate());

		endDate = event.getEndDate();
		if(endDate != null){
			endTime = helpers.DateHelper.getTime(event.getEndDate());
		}

		return "success";
	}

	public Event getEvent() {
		return event;
	}

	public void setEvent(Event event) {
		this.event = event;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public List<Location> getLocationList() {
		return locationList;
	}

	public void setLocationList(List<Location> locationList) {
		this.locationList = locationList;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

}
