package action.event;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.dispatcher.ServletDispatcherResult;

import com.opensymphony.xwork2.ActionContext;

import repository.DateUtil;

import manager.DAOManager;

import data.*;
import exception.NoSuchEventException;

/**
 * Retrieves Events for given day
 * 
 * @author Roland Krner
 * 
 */
@Result(name = "success", value = "/event/getEventsByDay.jsp", type = ServletDispatcherResult.class)
@Namespace(value = "/")
public class GetEventsByDayAction {

	private int day, month, year;
	private Date date, nextDate, previousDate;
	private List<Event> events;
	private User user;

	/**
	 * Retrieves Events for given day. If no day is given, events of the present
	 * day will be retrieved.
	 * 
	 * @return success
	 */
	public String execute() {

		GregorianCalendar now;
		user = (User) ActionContext.getContext().getSession().get("user");

		if (day == 0 || month == 0 || year == 0) {
			date = new Date();
			now = new GregorianCalendar();
			now.setTime(date);
			day = now.get(Calendar.DAY_OF_MONTH);
			month = now.get(Calendar.MONTH) + 1;
			year = now.get(Calendar.YEAR);
		}

		else
			now = DateUtil.get(day, month, year);

		date = now.getTime();

		now.add(Calendar.DAY_OF_MONTH, 1);
		nextDate = now.getTime();

		now.add(Calendar.DAY_OF_MONTH, -2);
		previousDate = now.getTime();

		try {
			setEvents(DAOManager.getEventDAO().getByDate(day, month, year));
		} catch (NoSuchEventException e) {
		}

		return "success";

	}

	public int getDay() {
		return day;
	}

	public void setDay(int day) {
		this.day = day;
	}

	public int getMonth() {
		return month;
	}

	public void setMonth(int month) {
		this.month = month;
	}

	public int getYear() {
		return year;
	}

	public void setYear(int year) {
		this.year = year;
	}

	public List<Event> getEvents() {
		return events;
	}

	public void setEvents(List<Event> events) {
		this.events = events;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public Date getNextDate() {
		return nextDate;
	}

	public void setNextDate(Date nextDate) {
		this.nextDate = nextDate;
	}

	public Date getPreviousDate() {
		return previousDate;
	}

	public void setPreviousDate(Date previousDate) {
		this.previousDate = previousDate;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}
}
