package action;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import data.*;
import exception.NoSuchArticleException;
import exception.NoSuchEventException;
import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.dispatcher.ServletDispatcherResult;

import com.opensymphony.xwork2.ActionContext;

import repository.DateUtil;

/**
 * Providing data for frontpage-display
 * 
 * @author Roland Krner
 * 
 */
@Result(name = "success", value = "/frontpage.jsp", type = ServletDispatcherResult.class)
@Namespace(value = "/")
public class frontpageAction {

	private List<Event> eventsToday, eventsTomorrow;
	private List<Article> articles;
	private List<Comment> comments;
	private Date today, tomorrow;
	private User user;

	/**
	 * Gets datasets for events of the actual day and the next day as well the last articles.
	 * @return success
	 */
	public String execute() {

		GregorianCalendar now = DateUtil.get();
		today = now.getTime();
		try {
			eventsToday = DAOManager.getEventDAO().getByDate(
					now.get(Calendar.DAY_OF_MONTH), now.get(Calendar.MONTH) + 1,
					now.get(Calendar.YEAR));

		} catch (NoSuchEventException e) {
			// ignore, if no event present
		}
		
		//next day
		now.add(Calendar.DAY_OF_MONTH, 1);
		tomorrow = now.getTime();
		try {
			eventsTomorrow = DAOManager.getEventDAO().getByDate(
					now.get(Calendar.DAY_OF_MONTH), now.get(Calendar.MONTH) + 1,
					now.get(Calendar.YEAR));
		} catch (NoSuchEventException e) {
			// ignore, if no event present
		}

		try {
			articles = DAOManager.getArticleDAO().getList();
		} catch (NoSuchArticleException e) {
			// ignore, if no article present
		}

		user = (User) ActionContext.getContext().getSession().get("user");

		return "success";
	}

	public List<Event> getEventsToday() {
		return eventsToday;
	}

	public void setEventsToday(List<Event> eventsToday) {
		this.eventsToday = eventsToday;
	}

	public List<Event> getEventsTomorrow() {
		return eventsTomorrow;
	}

	public void setEventsTomorrow(List<Event> eventsTomorrow) {
		this.eventsTomorrow = eventsTomorrow;
	}

	public List<Article> getArticles() {
		return articles;
	}

	public void setArticles(List<Article> articles) {
		this.articles = articles;
	}

	public List<Comment> getComments() {
		return comments;
	}

	public void setComments(List<Comment> comments) {
		this.comments = comments;
	}

	public Date getToday() {
		return today;
	}

	public void setToday(Date today) {
		this.today = today;
	}

	public Date getTomorrow() {
		return tomorrow;
	}

	public void setTomorrow(Date tomorrow) {
		this.tomorrow = tomorrow;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

}
