package action.location;

import java.util.List;

import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;

import data.Event;
import data.Location;
import exception.NoSuchEventException;
import exception.NoSuchLocationException;

/**
 * Retrieves data for location given by id and upcoming events for that location
 * 
 * @author Roland Krner
 * 
 */
@Results( {
		@Result(name = "success", value = "/location/locationDetail.jsp", type = ServletDispatcherResult.class),
		@Result(name = "error", value = "error.action", type = ServletRedirectResult.class) })
@Namespace(value = "/")
public class LocationDetailAction {

	private Location location;
	private int id;
	private List<Event> events;

	/**
	 * Retrieves data for location given by id and upcoming events for that
	 * location.
	 * 
	 * @return success<br>
	 *         error, if location doesn't exist
	 */
	public String execute() {

		try {
			setLocation(DAOManager.getLocationDAO().getById(id));
		} catch (NoSuchLocationException e) {
			return "error";
		}

		try {
			events = DAOManager.getEventDAO().getUpcomingByLocation(10, id);
		} catch (NoSuchEventException e) {
			// ignore
		} catch (NoSuchLocationException e) {
			// ignore
		}

		return "success";
	}

	public Location getLocation() {
		return location;
	}

	public void setLocation(Location location) {
		this.location = location;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public List<Event> getEvents() {
		return events;
	}

	public void setEvents(List<Event> events) {
		this.events = events;
	}

}
