package action.login;

import java.security.NoSuchAlgorithmException;
import java.util.Map;

import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import org.apache.struts2.dispatcher.ServletRedirectResult;
import repository.MD5Util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;

import data.User;
import exception.NoSuchUserException;

/**
 * Tries to log in a user by given nickname and password
 * 
 * @author Roland Krner
 *
 */
@Results({
	@Result(name="success", value="frontpage.action", type=ServletRedirectResult.class),
	@Result(name="input", value="/login/loginForm.jsp", type=ServletDispatcherResult.class)
})
@Namespace(value="/")
@Validation
public class LoginAction {
	
	private String userName, password;
	
	/**
	 * Tries to log in a user by given nickname and password.
	 * 
	 * @return success, if user was logged in,<br>
	 * 			input, else
	 */	@SuppressWarnings("unchecked")
	public String execute(){
		try {
			User user = DAOManager.getUserDAO().getByNickName(userName);
			//TODO: Hashing in DAO auslagern, muss transparent sein
			//TODO: userDAO.userIsValid(String username, String unhashedPassword)
			//TODO: java.security.NoSuchAlgorithmException im DAO handlen
			if(user.getPassword().equals(MD5Util.getHash(password))){
				Map session2 = ActionContext.getContext().getSession();
				java.util.Map<String, Object> session = session2;
					session.put("user", user);
				return "success";
			}
			else{
				return "input";
			}
		} catch (NoSuchUserException e) {
			return "input";
		} catch (NoSuchAlgorithmException e) {
			return "input";
		}
		
	}

	@RequiredStringValidator(message = "Nickname bentigt")
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	@RequiredStringValidator(message = "Passwort bentigt")
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

}
