package action.thread;

import helpers.PagerHelper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import data.ForumThread;
import data.Comment;
import data.User;
import exception.NoSuchForumThreadException;
import manager.DAOManager;

import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.Result;
import org.apache.struts2.dispatcher.ServletDispatcherResult;
import com.opensymphony.xwork2.ActionContext;

/**
 * Lists all threads and their comments
 * 
 * @author Roland Krner
 * 
 */
@Result(name = "success", value = "/thread/showThreads.jsp", type = ServletDispatcherResult.class)
@Namespace(value = "/")
public class ShowThreadsAction {

	private List<ForumThread> threads;
	private int id, threadPage, commentPage;
	private List<Comment> comments;
	private ForumThread thread;
	private String title, text, nickName;
	private Date creationDate;
	private User user;
	private ArrayList<Integer> threadPages, commentPages;

	/**
	 * Lists all threads and their comments.
	 * 
	 * @return success
	 */
	public String execute() {
		user = (User) ActionContext.getContext().getSession().get("user");

		try {
			threads = DAOManager.getForumThreadDAO().getList();
			if (id != 0) {
				comments = DAOManager.getForumThreadDAO().getById(id)
						.getComments();
				title = DAOManager.getForumThreadDAO().getById(id).getTitle();
				text = DAOManager.getForumThreadDAO().getById(id).getText();
				creationDate = DAOManager.getForumThreadDAO().getById(id)
						.getCreationDate();
				nickName = DAOManager.getForumThreadDAO().getById(id)
						.getOwner().getNickName();
			}
		} catch (NoSuchForumThreadException e) {
			return "success";
		}

		threadPages = new ArrayList<Integer>();
		commentPages = new ArrayList<Integer>();

		PagerHelper.fillArray(threads, threadPages, 15);
		PagerHelper.fillArray(comments, commentPages, 10);

		return "success";
	}

	public List<ForumThread> getThreads() {
		return threads;
	}

	public void setThreads(List<ForumThread> threads) {
		this.threads = threads;
	}

	public List<Comment> getComments() {
		return comments;
	}

	public void setComments(List<Comment> comments) {
		this.comments = comments;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}

	public ForumThread getSelectedTread() {
		return thread;
	}

	public void setSelectedTread(ForumThread selectedTread) {
		this.thread = selectedTread;
	}

	public int getThreadPage() {
		return threadPage;
	}

	public void setThreadPage(int threadPage) {
		this.threadPage = threadPage;
	}

	public int getCommentPage() {
		return commentPage;
	}

	public void setCommentPage(int commentPage) {
		this.commentPage = commentPage;
	}

	public ForumThread getThread() {
		return thread;
	}

	public void setThread(ForumThread thread) {
		this.thread = thread;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public ArrayList<Integer> getThreadPages() {
		return threadPages;
	}

	public void setThreadPages(ArrayList<Integer> threadPages) {
		this.threadPages = threadPages;
	}

	public ArrayList<Integer> getCommentPages() {
		return commentPages;
	}

	public void setCommentPages(ArrayList<Integer> commentPages) {
		this.commentPages = commentPages;
	}

	public Date getCreationDate() {
		return creationDate;
	}
}
