package data;

import java.util.Date;
import java.util.List;
import java.util.LinkedList;
import java.util.Set;
import java.util.HashSet;

/**
 * Presents an article. An article is usually written by an editor
 * and has some tags, comments and one image.
 * 
 * @author Ferdinand Kaiser
 *
 */
public class Article extends Entry{

	private List<Comment> comments=new LinkedList<Comment>();
	private Set<Tag> tags=new HashSet<Tag>();
	private Image image;

	public Article(){
		
	}
	
	/**
	 * 
	 * @param owner owner of the article
	 * @param title title of the article
	 * @param creationDate date when article was created
	 * @param text text of the article
	 * @param lastEdit date when article was last edited
	 * @param visible true if it is to be displayed 
	 * @param image 
	 */
	public Article( User owner, String title, Date creationDate,
			String text, Date lastEdit, boolean visible,Image image) {
		super(owner, title, creationDate, text, lastEdit, visible);
		this.image=image;
	}

	
	/**
	 * 
	 * @return image assigned to the article
	 */
	public Image getImage() {
		return image;
	}

	/**
	 * sets the assigned image
	 * @param image
	 */
	public void setImage(Image image) {
		this.image = image;
	}

	/**
	 * 
	 * @return a list of comments assigned to this article
	 */
	public List<Comment> getComments() {
		return comments;
	}

	/**
	 * sets the list of articles, only to be used by Hibernate
	 * @param comments
	 */
	public void setComments(List<Comment> comments) {
		this.comments = comments;
	}

	/**
	 * 
	 * @return a list of tags assigned to this article
	 */
	public Set<Tag> getTags() {
		return tags;
	}

	/**
	 * sets the list of tags, only to be used by Hibernate
	 * @param tags
	 */
	public void setTags(Set<Tag> tags) {
		this.tags = tags;
	}

	

}
