package data;

import java.util.Date;
/**
 * Presents a comment, a comment is always associated with an Article, Event or
 * ForumThread. 
 * @author Ferdinand Kaiser
 */
public class Comment extends Entry {
	
	private int parentId;
	
	/**
	 * 
	 * @param owner owner of the entry
	 * @param title title of the entry
	 * @param creationDate date when entry was created
	 * @param text text of the entry
	 * @param lastEdit date when entry was last edited
	 * @param visible if this is set to true, the entry will not be displayed to the user
	 */
	public Comment(User owner, String title, Date creationDate, String text,
			Date lastEdit, boolean deleted) {
		super(owner, title, creationDate, text, lastEdit, deleted);
	}

	public Comment(){
		
	}

	/**
	 * 
	 * @return the id of the associated entry
	 */
	public int getParentId() {
		return parentId;
	}

	/**
	 * sets the id of the associated entry, this method is only to be used by Hibernate!
	 * @param parentId
	 */
	public void setParentId(int parentId) {
		this.parentId = parentId;
	}
	
}
