package data;

import java.util.Date;

/**
 * Parent class encapsulates the common features of
 * Article, Event, Comment, ForumThread.
 * 
 * @author Ferdinand Kaiser
 */
public class Entry {
	
	private int id;
	private User owner;
	private String title;
	private Date creationDate;
	private String text;
	private Date lastEdit;
	private boolean visible;
	
	public Entry(){
		
	}
	
	/**
	 * 
	 * @param owner owner of the entry
	 * @param title title of the entry
	 * @param creationDate date when entry was created
	 * @param text text of the entry
	 * @param lastEdit date when entry was last edited
	 * @param visible if this is set to true, the entry will not be displayed to the user
	 */
	public Entry(User owner, String title, Date creationDate,
			String text, Date lastEdit, boolean visible) {
		this.owner = owner;
		this.title = title;
		this.creationDate = creationDate;
		this.text = text;
		this.lastEdit = lastEdit;
		this.visible = visible;
	}	
	
	/**
	 * 
	 * @return the unique id
	 */
	public int getId() {
		return id;
	}
	

	/**
	 * sets the unique id<br>
	 * this method is to be used by Hibernate only
	 * @param id unique id
	 */
	private void setId(int id) {
		this.id = id;
	}
	
	/**
	 * 
	 * @return the title of the entry
	 */
	public String getTitle() {
		return title;
	}
	
	/**
	 * sets the title of the entry
	 * @param title
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	
	/**
	 * 
	 * @return date when entry was created
	 */
	public Date getCreationDate() {
		return creationDate;
	}
	
	/**
	 * sets date when entry was created
	 * @param creationDate
	 */
	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}
	
	/**
	 * 
	 * @return text of the entry 
	 */
	public String getText() {
		return text;
	}
	
	/**
	 * sets the text of the entry
	 * @param text
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	/**
	 * 
	 * @return date when entry was last edited
	 */
	public Date getLastEdit() {
		return lastEdit;
	}
	
	/**
	 * sets date when entry was last edited
	 * @param lastEdit
	 */
	public void setLastEdit(Date lastEdit) {
		this.lastEdit = lastEdit;
	}
	
	/**
	 * 
	 * @return true if entry is visible, which means it is displayed
	 */
	public boolean isVisible() {
		return visible;
	}
	
	/**
	 * set this to true, if it shall be displayed
	 * @param visible
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}

	/**
	 * 
	 * @return owner of the entry
	 */
	public User getOwner() {
		return owner;
	}

	/**
	 * sets owner of the entry
	 * @param owner
	 */
	public void setOwner(User owner) {
		this.owner = owner;
	}

	

}
