package data;

/**
 * Presents a location, a location is usually assigned to an event and created by a registered user.
 * A location has a name, street, postalcode, city, description and a (http)link.
 * @author Ferdinand Kaiser, 05.05.2008
 */
public class Location {
	
	private int id;
	private String name;
	private String street;
	private String postalCode;
	private String city;
	private String description;
	private String link;

	public Location(){
		
	}
	
	/**
	 * 
	 * @param name name of the location
	 * @param street street of the location
	 * @param postalCode postal code of the location
	 * @param city city of the location
	 * @param description description of the location
	 * @param link link to the homepage of the location
	 */
	public Location(String name, String street, String postalCode, String city,
			String description, String link) {
		super();
		this.name = name;
		this.street = street;
		this.postalCode = postalCode;
		this.city = city;
		this.description = description;
		this.link = link;
	}	
	
	/**
	 * 
	 * @return unique id
	 */
	public int getId() {
		return id;
	}

	/**
	 * sets the unique id, only to be used by Hibernate!
	 * @param id
	 */
	private void setId(int id) {
		this.id = id;
	}
	
	/**
	 * 
	 * @return name of the location
	 */
	public String getName() {
		return name;
	}

	/**
	 * sets name of the location
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 
	 * @return street of the location
	 */
	public String getStreet() {
		return street;
	}
	
	/**
	 * sets street of the location
	 * @param street
	 */
	public void setStreet(String street) {
		this.street = street;
	}
	
	/**
	 * 
	 * @return postal code of the location
	 */
	public String getPostalCode() {
		return postalCode;
	}

	/**
	 * sets  postal code of the location
	 * @param postalCode
	 */
	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}
	
	/**
	 * 
	 * @return description of the location
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * sets description of the location
	 * @param description
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 
	 * @return (http)link of the location
	 */
	public String getLink() {
		return link;
	}
	
	/**
	 * sets (http)link of the location
	 * @param link
	 */
	public void setLink(String link) {
		this.link = link;
	}

	/**
	 * 
	 * @return name of the city of the location
	 */
	public String getCity() {
		return city;
	}

	/**
	 * sets name of the city of the location
	 * @param city
	 */
	public void setCity(String city) {
		this.city = city;
	}

}
